/*
 * Decompiled with CFR 0.152.
 */
package me.melontini.dark_matter.impl.base.util.mixin;

import java.util.Map;
import me.melontini.dark_matter.api.base.util.Mapper;
import me.melontini.dark_matter.api.base.util.Utilities;
import me.melontini.dark_matter.api.base.util.mixin.AsmUtil;
import me.melontini.dark_matter.api.base.util.mixin.IPluginPlugin;
import me.melontini.dark_matter.api.base.util.mixin.annotations.ConstructDummy;
import me.melontini.dark_matter.impl.base.DarkMatterLog;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.util.Annotations;

public class ConstructDummyPlugin
implements IPluginPlugin {
    @Override
    public void beforeApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
        ClassNode mixinNode = mixinInfo.getClassNode(7);
        for (MethodNode method : mixinNode.methods) {
            AnnotationNode node = Annotations.getVisible((MethodNode)method, ConstructDummy.class);
            if (node == null) continue;
            if (targetClass.superName == null) {
                throw new IllegalStateException("Target class does not have a super class!");
            }
            if (Annotations.getVisible((MethodNode)method, Inject.class) == null) {
                throw new IllegalStateException("@ConstructDummy can only be applied to methods annotated with @Inject!");
            }
            Map<String, Object> values = AsmUtil.mapAnnotationNode(node);
            String owner = (String)Utilities.cast(values.get("owner"));
            String name = (String)Utilities.cast(values.get("name"));
            String desc = (String)Utilities.cast(values.get("desc"));
            int access = (Integer)Utilities.cast(values.getOrDefault("access", 1));
            Type descType = Type.getType((String)desc);
            String mappedName = Mapper.mapMethod(owner, name, desc);
            String mappedDesc = Mapper.mapMethodDescriptor(descType);
            Type mappedDescType = Type.getType((String)mappedDesc);
            for (MethodNode methodNode : targetClass.methods) {
                if (!mappedName.equals(methodNode.name) || !mappedDesc.equals(methodNode.desc)) continue;
                DarkMatterLog.debug("Skipped creating dummy method {}.{}{} as it already exists", targetClass.name, mappedName, mappedDesc);
                return;
            }
            AsmUtil.insAdapter((ClassVisitor)targetClass, access, mappedName, mappedDesc, ia -> {
                ia.load(0, Type.getType(Object.class));
                Type[] args = mappedDescType.getArgumentTypes();
                for (int i = 0; i < args.length; ++i) {
                    ia.load(i + 1, args[i]);
                }
                ia.invokespecial(targetClass.superName.replace(".", "/"), mappedName, mappedDesc, false);
                ia.areturn(mappedDescType.getReturnType());
                ia.visitLocalVariable("this", "L" + targetClass.name + ";", null, new Label(), new Label(), 0);
                ia.visitMaxs(args.length + 1, args.length + 1);
            });
            DarkMatterLog.debug("Successfully created and added a dummy method {}.{}{}", targetClass.name, mappedName, mappedDesc);
        }
    }
}

