/*
 * Decompiled with CFR 0.152.
 */
package me.melontini.dark_matter.impl.base.util.mixin;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import me.melontini.dark_matter.api.base.reflect.Reflect;
import me.melontini.dark_matter.api.base.util.classes.Tuple;
import me.melontini.dark_matter.api.base.util.mixin.AsmUtil;
import me.melontini.dark_matter.api.base.util.mixin.IAsmTransformer;
import me.melontini.dark_matter.api.base.util.mixin.IPluginPlugin;
import me.melontini.dark_matter.api.base.util.mixin.annotations.AsmTransformers;
import me.melontini.dark_matter.impl.base.DarkMatterLog;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.util.Annotations;

public class AsmTransformerPlugin
implements IPluginPlugin {
    private final HashMap<Tuple<String, String>, Set<IAsmTransformer>> transformers = new HashMap();

    @Override
    public void beforeApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
        ClassNode mixinNode = mixinInfo.getClassNode(7);
        AnnotationNode node = Annotations.getVisible((ClassNode)mixinNode, AsmTransformers.class);
        if (node == null) {
            return;
        }
        List types = AsmUtil.getAnnotationValue(node, "value", null);
        if (types == null) {
            return;
        }
        for (Type type : types) {
            try {
                Class<?> cls = Class.forName(type.getClassName());
                if (IAsmTransformer.class.isAssignableFrom(cls)) {
                    Set transformers = this.transformers.computeIfAbsent(Tuple.of(mixinInfo.getClassName(), targetClassName), k -> new HashSet());
                    transformers.add((IAsmTransformer)Reflect.setAccessible(cls.getDeclaredConstructor(new Class[0])).newInstance(new Object[0]));
                    DarkMatterLog.debug("Added transformer {} to mixin {}", type.getClassName(), mixinInfo.getClassName());
                    continue;
                }
                throw new IllegalStateException("javac failed me. %s is not a transformer!".formatted(type.getClassName()));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Specified transformer class not found! " + type.getClassName(), e);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException("Failed to construct transformer class! " + type.getClassName(), e);
            }
        }
        Set<IAsmTransformer> transformers = this.transformers.get(Tuple.of(mixinInfo.getClassName(), targetClassName));
        if (transformers != null) {
            transformers.forEach(transformer -> transformer.beforeApply(targetClass, mixinInfo));
        }
    }

    @Override
    public void afterApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
        Set<IAsmTransformer> transformers = this.transformers.get(Tuple.of(mixinInfo.getClassName(), targetClassName));
        if (transformers != null) {
            transformers.forEach(transformer -> transformer.afterApply(targetClass, mixinInfo));
        }
    }
}

