/*
 * Decompiled with CFR 0.152.
 */
package me.melontini.dark_matter.impl.base.util.mixin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.melontini.dark_matter.api.base.util.Utilities;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;

public final class AsmImpl {
    private static final List<Map<String, Object>> EMPTY_ANN_LIST = Collections.unmodifiableList(new ArrayList());

    public static <T> T getAnnotationValue(AnnotationNode node, String name, T defaultValue) {
        if (node == null || node.values == null) {
            return defaultValue;
        }
        for (int i = 0; i < node.values.size(); i += 2) {
            if (!name.equals(node.values.get(i))) continue;
            return (T)Utilities.cast(AsmImpl.mapObjectFromAnnotation(node.values.get(i + 1)));
        }
        return defaultValue;
    }

    public static Map<String, Object> mapAnnotationNode(AnnotationNode node) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        if (node == null || node.values == null) {
            return values;
        }
        for (int i = 0; i < node.values.size(); i += 2) {
            String name = (String)node.values.get(i);
            Object value = AsmImpl.mapObjectFromAnnotation(node.values.get(i + 1));
            if (name == null || value == null) continue;
            values.putIfAbsent(name, value);
        }
        return values;
    }

    public static Object mapObjectFromAnnotation(Object value) {
        return AsmImpl.mapObjectFromAnnotation(value, true, false);
    }

    public static Object mapObjectFromAnnotation(Object value, boolean loadEnums, boolean loadClasses) {
        block12: {
            if (value instanceof List) {
                List list = (List)value;
                ArrayList<Object> process = new ArrayList<Object>(list.size());
                for (Object o : list) {
                    process.add(AsmImpl.mapObjectFromAnnotation(o));
                }
                return process;
            }
            if (value instanceof AnnotationNode) {
                AnnotationNode node = (AnnotationNode)value;
                return AsmImpl.mapAnnotationNode(node);
            }
            if (value instanceof Type) {
                Type type = (Type)value;
                if (loadClasses) {
                    try {
                        return Class.forName(type.getClassName());
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            if (value instanceof String[]) {
                String[] enum0 = (String[])value;
                if (loadEnums) {
                    try {
                        Class<?> cls = Class.forName(enum0[0].replace("/", ".").substring(1, enum0[0].length() - 1));
                        if (Enum.class.isAssignableFrom(cls)) {
                            value = Enum.valueOf((Class)Utilities.cast(cls), enum0[1]);
                            return value;
                        }
                        break block12;
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            return value;
        }
        return value;
    }

    public static List<Map<String, Object>> emptyAnnotationList() {
        return EMPTY_ANN_LIST;
    }

    private AsmImpl() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

