/*
 * Decompiled with CFR 0.152.
 */
package me.melontini.dark_matter.impl.base.reflect;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import me.melontini.dark_matter.api.base.util.MakeSure;
import me.melontini.dark_matter.api.base.util.Utilities;
import me.melontini.dark_matter.api.base.util.classes.Lazy;
import me.melontini.dark_matter.impl.base.reflect.ReflectionInternals;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import sun.misc.Unsafe;

@ApiStatus.Internal
public final class UnsafeInternals {
    private static final Lazy<Unsafe> UNSAFE = Lazy.of(() -> () -> {
        try {
            Field unsafe = Unsafe.class.getDeclaredField("theUnsafe");
            unsafe.setAccessible(true);
            return (Unsafe)unsafe.get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            try {
                Constructor constructor = Unsafe.class.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                return (Unsafe)constructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                throw new RuntimeException("Couldn't access Unsafe", ex);
            }
        }
    });
    private static final Lazy<Object> internalUnsafe = Lazy.of(() -> () -> UnsafeInternals.getReference(Unsafe.class.getDeclaredField("theInternalUnsafe"), null));
    private static final Lazy<MethodHandle> objectFieldOffset = Lazy.of(() -> () -> ReflectionInternals.trustedLookup().findVirtual(UnsafeInternals.internalUnsafe().getClass(), "objectFieldOffset", MethodType.methodType(Long.TYPE, Class.class, String.class)));
    private static int offset = -1;

    public static void setReference(Field field, Object o, Object value) {
        boolean isVolatile;
        boolean isStatic = Modifier.isStatic(field.getModifiers());
        boolean bl = isVolatile = Modifier.isVolatile(field.getModifiers()) || Modifier.isFinal(field.getModifiers());
        if (isVolatile) {
            UnsafeInternals.getUnsafe().putObjectVolatile(isStatic ? UnsafeInternals.getUnsafe().staticFieldBase(field) : o, isStatic ? UnsafeInternals.getUnsafe().staticFieldOffset(field) : UnsafeInternals.getUnsafe().objectFieldOffset(field), value);
        } else {
            UnsafeInternals.getUnsafe().putObject(isStatic ? UnsafeInternals.getUnsafe().staticFieldBase(field) : o, isStatic ? UnsafeInternals.getUnsafe().staticFieldOffset(field) : UnsafeInternals.getUnsafe().objectFieldOffset(field), value);
        }
    }

    public static <T> T getReference(Field field, Object o) {
        boolean isVolatile;
        boolean isStatic = Modifier.isStatic(field.getModifiers());
        boolean bl = isVolatile = Modifier.isVolatile(field.getModifiers()) || Modifier.isFinal(field.getModifiers());
        if (isVolatile) {
            return (T)Utilities.cast(UnsafeInternals.getUnsafe().getObjectVolatile(isStatic ? UnsafeInternals.getUnsafe().staticFieldBase(field) : o, isStatic ? UnsafeInternals.getUnsafe().staticFieldOffset(field) : UnsafeInternals.getUnsafe().objectFieldOffset(field)));
        }
        return (T)Utilities.cast(UnsafeInternals.getUnsafe().getObject(isStatic ? UnsafeInternals.getUnsafe().staticFieldBase(field) : o, isStatic ? UnsafeInternals.getUnsafe().staticFieldOffset(field) : UnsafeInternals.getUnsafe().objectFieldOffset(field)));
    }

    public static <T> T allocateInstance(Class<T> cls) throws InstantiationException {
        return (T)Utilities.cast(UnsafeInternals.getUnsafe().allocateInstance(cls));
    }

    public static Unsafe getUnsafe() {
        return UNSAFE.get();
    }

    @Deprecated
    @Nullable
    public static Object internalUnsafe() {
        return internalUnsafe.get();
    }

    @Deprecated
    public static long getObjectFieldOffset(Class<?> clazz, String name) {
        try {
            return (Long)objectFieldOffset.get().invokeWithArguments(UnsafeInternals.internalUnsafe(), clazz, name);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static int getOverrideOffset() {
        if (offset == -1) {
            try {
                Field f = Unsafe.class.getDeclaredField("theUnsafe");
                Field f1 = Unsafe.class.getDeclaredField("theUnsafe");
                f.setAccessible(true);
                f1.setAccessible(false);
                Unsafe unsafe = (Unsafe)f.get(null);
                int i = 0;
                while (unsafe.getBoolean(f, i) == unsafe.getBoolean(f1, i)) {
                    ++i;
                }
                offset = i;
            }
            catch (Exception ignored) {
                offset = 12;
            }
        }
        MakeSure.isTrue(offset != -1);
        return offset;
    }

    private UnsafeInternals() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

