/*
 * Decompiled with CFR 0.152.
 */
package me.melontini.dark_matter.impl.base.reflect;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import me.melontini.dark_matter.api.base.reflect.Reflect;
import me.melontini.dark_matter.api.base.reflect.UnsafeAccess;
import me.melontini.dark_matter.api.base.util.MakeSure;
import me.melontini.dark_matter.api.base.util.classes.Lazy;
import me.melontini.dark_matter.impl.base.reflect.MiscReflectionInternals;
import org.apache.commons.lang3.ClassUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ReflectionInternals {
    private static final Lazy<VarHandle> override = Lazy.of(() -> () -> ReflectionInternals.trustedLookup().findVarHandle(AccessibleObject.class, "override", Boolean.TYPE));
    private static final Lazy<MethodHandles.Lookup> trustedLookup = Lazy.of(() -> () -> (MethodHandles.Lookup)UnsafeAccess.getReference(MethodHandles.Lookup.class.getDeclaredField("IMPL_LOOKUP"), null));

    @Nullable
    public static <T> Constructor<T> findConstructor(@NotNull Class<T> clazz, Class<?> ... classes) {
        Constructor<?>[] ctxs = clazz.getDeclaredConstructors();
        if (clazz.getDeclaredConstructors().length == 1) {
            return ReflectionInternals.checkCtx(ctxs[0], classes) ? ctxs[0] : null;
        }
        try {
            return clazz.getDeclaredConstructor(classes);
        }
        catch (Exception e) {
            for (Constructor<?> ctx : ctxs) {
                if (!ReflectionInternals.checkCtx(ctx, classes)) continue;
                return ctx;
            }
            return null;
        }
    }

    private static boolean checkCtx(Constructor<?> ctx, Class<?>[] classes) {
        if (ctx.getParameterCount() != classes.length) {
            return false;
        }
        Class<?>[] pt = ctx.getParameterTypes();
        for (int i = 0; i < ctx.getParameterCount(); ++i) {
            if (ClassUtils.isAssignable(classes[i], pt[i])) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static <T> Method findMethod(@NotNull Class<T> clazz, boolean traverse, String name, Class<?> ... classes) {
        Method[] methods = clazz.getDeclaredMethods();
        if (methods.length == 1) {
            return ReflectionInternals.checkMethod(methods[0], name, classes) ? methods[0] : null;
        }
        try {
            return clazz.getDeclaredMethod(name, classes);
        }
        catch (Throwable e) {
            for (Method method : methods) {
                if (!ReflectionInternals.checkMethod(method, name, classes)) continue;
                return method;
            }
            return traverse && clazz.getSuperclass() != null ? ReflectionInternals.findMethod(clazz.getSuperclass(), true, name, classes) : null;
        }
    }

    private static boolean checkMethod(Method method, String name, Class<?>[] classes) {
        if (!method.getName().equals(name)) {
            return false;
        }
        if (method.getParameterCount() != classes.length) {
            return false;
        }
        Class<?>[] pt = method.getParameterTypes();
        for (int i = 0; i < method.getParameterCount(); ++i) {
            if (ClassUtils.isAssignable(classes[i], pt[i])) continue;
            return false;
        }
        return true;
    }

    public static <T> Field findField(Class<T> clazz, boolean traverse, String name) {
        Field[] fields = clazz.getDeclaredFields();
        if (fields.length == 1) {
            return fields[0].getName().equals(name) ? fields[0] : null;
        }
        for (Field field : fields) {
            if (!field.getName().equals(name)) continue;
            return field;
        }
        return traverse && clazz.getSuperclass() != null ? ReflectionInternals.findField(clazz.getSuperclass(), true, name) : null;
    }

    public static <T extends AccessibleObject> T setAccessible(T member, boolean set) {
        MakeSure.notNull(member, "Tried to setAccessible a null constructor");
        try {
            member.setAccessible(set);
        }
        catch (Exception e) {
            override.get().set(member, set);
        }
        return member;
    }

    public static MethodHandles.Lookup trustedLookup() throws Exception {
        return trustedLookup.getExc();
    }

    public static Field getField(Class<?> clazz, String name, boolean accessible) {
        try {
            return Reflect.findField(clazz, name).map(field -> accessible ? ReflectionInternals.setAccessible(field, true) : field).orElseThrow(() -> new NoSuchFieldException(name));
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object getField(Field field, Object o) {
        try {
            return ReflectionInternals.trustedLookup().unreflectGetter(field).invoke(o);
        }
        catch (Throwable e) {
            return UnsafeAccess.getReference(field, o);
        }
    }

    public static void setField(Field field, Object o, Object value) {
        try {
            MiscReflectionInternals.tryRemoveFinal(ReflectionInternals.setAccessible(field, true)).set(o, value);
        }
        catch (Throwable e) {
            UnsafeAccess.putReference(field, o, value);
        }
    }

    private ReflectionInternals() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

