/*
 * Decompiled with CFR 0.152.
 */
package me.melontini.dark_matter.impl.base.reflect;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.ProtectionDomain;
import me.melontini.dark_matter.api.base.util.MakeSure;
import me.melontini.dark_matter.api.base.util.classes.Lazy;
import me.melontini.dark_matter.impl.base.reflect.ReflectionInternals;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MiscReflectionInternals {
    private static final Lazy<MethodHandle> defineClass = Lazy.of(() -> () -> ReflectionInternals.trustedLookup().findVirtual(ClassLoader.class, "defineClass", MethodType.methodType(Class.class, String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class)));
    private static final Lazy<VarHandle> modifiers = Lazy.of(() -> () -> ReflectionInternals.trustedLookup().findVarHandle(Field.class, "modifiers", Integer.TYPE));
    private static final Lazy<VarHandle> fieldAccessor = Lazy.of(() -> () -> ReflectionInternals.trustedLookup().findVarHandle(Field.class, "fieldAccessor", Class.forName("jdk.internal.reflect.FieldAccessor")));
    private static final Lazy<VarHandle> overrideFieldAccessor = Lazy.of(() -> () -> ReflectionInternals.trustedLookup().findVarHandle(Field.class, "overrideFieldAccessor", Class.forName("jdk.internal.reflect.FieldAccessor")));
    private static final Lazy<MethodHandle> addOpensOrExports = Lazy.of(() -> () -> ReflectionInternals.trustedLookup().findVirtual(Module.class, "implAddExportsOrOpens", MethodType.methodType(Void.TYPE, String.class, Module.class, Boolean.TYPE, Boolean.TYPE)));
    private static final Lazy<MethodHandle> addUses = Lazy.of(() -> () -> ReflectionInternals.trustedLookup().findVirtual(Module.class, "implAddUses", MethodType.methodType(Void.TYPE, Class.class)));
    private static final Lazy<MethodHandle> addReads = Lazy.of(() -> () -> ReflectionInternals.trustedLookup().findVirtual(Module.class, "implAddReads", MethodType.methodType(Void.TYPE, Module.class, Boolean.TYPE)));
    private static final Lazy<MethodHandle> forName0 = Lazy.of(() -> () -> ReflectionInternals.trustedLookup().findStatic(Class.class, "forName0", MethodType.methodType(Class.class, String.class, Boolean.TYPE, ClassLoader.class, Class.class)));
    private static final Lazy<MethodHandle> memberNameCtx = Lazy.of(() -> () -> ReflectionInternals.trustedLookup().findConstructor(Class.forName("java.lang.invoke.MemberName"), MethodType.methodType(Void.TYPE, Field.class, Boolean.TYPE)));
    private static final Lazy<MethodHandle> resolveOrFail = Lazy.of(() -> () -> ReflectionInternals.trustedLookup().findVirtual(MethodHandles.Lookup.class, "resolveOrFail", MethodType.methodType(Class.forName("java.lang.invoke.MemberName"), Byte.TYPE, Class.class, String.class, Class.class)));

    public static Class<?> defineClass(ClassLoader loader, @Nullable String name, byte[] bytes, @Nullable ProtectionDomain domain) throws Throwable {
        return (Class)defineClass.getExc().invokeWithArguments(loader, name, bytes, 0, bytes.length, domain);
    }

    public static Field tryRemoveFinal(Field f) throws Throwable {
        MakeSure.notNull(f, "Tried to remove final from a null field");
        if (Modifier.isFinal(f.getModifiers())) {
            modifiers.getExc().set(f, modifiers.get().get(f) & 0xFFFFFFEF);
            fieldAccessor.getExc().set(f, null);
            overrideFieldAccessor.getExc().set(f, null);
        }
        return f;
    }

    public static void addOpensOrExports(Module module, String pn, Module other, boolean open, boolean syncVM) throws Throwable {
        addOpensOrExports.getExc().invokeWithArguments(module, pn, other, open, syncVM);
    }

    public static void addUses(Module module, Class<?> clazz) throws Throwable {
        addUses.getExc().invokeWithArguments(module, clazz);
    }

    public static void addReads(Module module, Module other, boolean syncVM) throws Throwable {
        addReads.getExc().invokeWithArguments(module, other, syncVM);
    }

    @NotNull
    public static MethodHandles.Lookup lookupIn(Class<?> clazz) throws Exception {
        return ReflectionInternals.trustedLookup().in(clazz);
    }

    public static Class<?> accessRestrictedClass(String name, @Nullable ClassLoader loader) throws Throwable {
        return (Class)forName0.getExc().invokeWithArguments(null, name, false, loader, Class.class);
    }

    public static VarHandle unreflectVarHandle(Field f) throws Throwable {
        Object m = memberNameCtx.getExc().invoke(f, false);
        return MiscReflectionInternals.makeFieldHandle(m, f.getDeclaringClass(), f.getType());
    }

    public static VarHandle findVarHandle(Class<?> cls, String name, Class<?> type) throws Throwable {
        Object m = resolveOrFail.getExc().invokeWithArguments(ReflectionInternals.trustedLookup(), (byte)1, cls, name, type);
        return MiscReflectionInternals.makeFieldHandle(m, cls, type);
    }

    public static VarHandle findStaticVarHandle(Class<?> cls, String name, Class<?> type) throws Throwable {
        Object m = resolveOrFail.getExc().invokeWithArguments(ReflectionInternals.trustedLookup(), (byte)2, cls, name, type);
        return MiscReflectionInternals.makeFieldHandle(m, cls, type);
    }

    private static VarHandle makeFieldHandle(Object m, Class<?> refc, Class<?> type) {
        try {
            return ReflectionInternals.trustedLookup().findStatic(Class.forName("java.lang.invoke.VarHandles"), "makeFieldHandle", MethodType.methodType(VarHandle.class, Class.forName("java.lang.invoke.MemberName"), Class.class, Class.class, Boolean.TYPE)).invoke(m, refc, type, true);
        }
        catch (Throwable t) {
            try {
                return ReflectionInternals.trustedLookup().findStatic(Class.forName("java.lang.invoke.VarHandles"), "makeFieldHandle", MethodType.methodType(VarHandle.class, Class.forName("java.lang.invoke.MemberName"), Class.class, Boolean.TYPE)).invoke(m, refc, true);
            }
            catch (Throwable t2) {
                throw new RuntimeException(t2);
            }
        }
    }

    private MiscReflectionInternals() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

