/*
 * Decompiled with CFR 0.152.
 */
package me.melontini.dark_matter.impl.base.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.melontini.dark_matter.api.base.config.ConfigManager;

public class ConfigManagerImpl<T>
implements ConfigManager<T> {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final Class<T> cls;
    private final String name;
    private final Supplier<T> constructor;
    private final Set<Consumer<JsonObject>> fixers = new LinkedHashSet<Consumer<JsonObject>>();
    private final Set<ConfigManager.Listener<T>> save = new LinkedHashSet<ConfigManager.Listener<T>>();
    private final Set<ConfigManager.Listener<T>> load = new LinkedHashSet<ConfigManager.Listener<T>>();
    private final Set<ConfigManager.Handler> handlers = new LinkedHashSet<ConfigManager.Handler>();

    public ConfigManagerImpl(Class<T> cls, String name, Supplier<T> constructor) {
        this.cls = cls;
        this.name = name;
        this.constructor = constructor;
    }

    @Override
    public ConfigManager<T> fixup(Consumer<JsonObject> fixer) {
        this.fixers.add(fixer);
        return this;
    }

    @Override
    public T createDefault() {
        return this.constructor.get();
    }

    @Override
    public T load(Path root) {
        Path path = this.resolve(root);
        AtomicReference<Object> config = new AtomicReference<Object>();
        if (Files.exists(path, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(path);){
                JsonObject json = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                this.fixers.forEach(fixer -> fixer.accept(json));
                config.set(GSON.fromJson((JsonElement)json, this.type()));
            }
            catch (Exception e) {
                this.handlers.forEach(handler -> handler.accept(e, ConfigManager.Stage.LOAD, path));
                config.set(this.createDefault());
            }
        } else {
            config.set(this.createDefault());
        }
        this.load.forEach(listener -> listener.accept(config.get(), path));
        return (T)config.get();
    }

    @Override
    public void save(Path root, T config) {
        Path path = this.resolve(root);
        this.save.forEach(listener -> listener.accept(config, path));
        try {
            byte[] old;
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            byte[] cfg = GSON.toJson(config).getBytes();
            if (Files.exists(path, new LinkOption[0]) && Arrays.equals(old = Files.readAllBytes(path), cfg)) {
                return;
            }
            Files.write(path, cfg, new OpenOption[0]);
        }
        catch (Exception e) {
            this.handlers.forEach(handler -> handler.accept(e, ConfigManager.Stage.SAVE, path));
        }
    }

    @Override
    public Path resolve(Path root) {
        return root.resolve(this.name() + ".json");
    }

    @Override
    public ConfigManager<T> onSave(ConfigManager.Listener<T> listener) {
        this.save.add(listener);
        return this;
    }

    @Override
    public ConfigManager<T> onLoad(ConfigManager.Listener<T> listener) {
        this.load.add(listener);
        return this;
    }

    @Override
    public ConfigManager<T> exceptionHandler(ConfigManager.Handler handler) {
        this.handlers.add(handler);
        return this;
    }

    @Override
    public Class<T> type() {
        return this.cls;
    }

    @Override
    public String name() {
        return this.name;
    }
}

