/*
 * Decompiled with CFR 0.152.
 */
package me.melontini.dark_matter.api.base.util.mixin;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import me.melontini.dark_matter.api.base.util.mixin.AsmUtil;
import me.melontini.dark_matter.api.base.util.mixin.ExtendablePlugin;
import me.melontini.dark_matter.api.base.util.mixin.IPluginPlugin;
import me.melontini.dark_matter.api.base.util.mixin.MixinShouldApply;
import me.melontini.dark_matter.api.base.util.mixin.Mod;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.MappingResolver;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.SemanticVersion;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.VersionParsingException;
import net.fabricmc.loader.api.metadata.version.VersionPredicate;
import org.jetbrains.annotations.ApiStatus;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.service.MixinService;

@ApiStatus.Obsolete
public class ExtendedPlugin
implements IMixinConfigPlugin {
    protected static final MappingResolver MAPPING_RESOLVER = FabricLoader.getInstance().getMappingResolver();
    protected static final BiPredicate<String, Mod.Mode> MOD_PREDICATE = (s, mode) -> switch (mode) {
        default -> throw new IncompatibleClassChangeError();
        case Mod.Mode.LOADED -> FabricLoader.getInstance().isModLoaded(s);
        case Mod.Mode.NOT_LOADED -> !FabricLoader.getInstance().isModLoaded(s);
    };
    protected static final EnvType ENV_TYPE = FabricLoader.getInstance().getEnvironmentType();
    protected static final Version MC_VERSION = ExtendedPlugin.parseMCVersion();
    private static final String SHOULD_APPLY_DESC = "L" + MixinShouldApply.class.getName().replace(".", "/") + ";";
    private final IPluginPlugin shouldApplyPlugin = ExtendablePlugin.DefaultPlugins.shouldApplyPlugin();

    public void onLoad(String mixinPackage) {
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        try {
            ArrayList<AnnotationNode> annotationNodes = new ArrayList<AnnotationNode>();
            ClassNode node = MixinService.getService().getBytecodeProvider().getClassNode(mixinClassName);
            if (node.visibleAnnotations != null) {
                annotationNodes.addAll(node.visibleAnnotations);
            }
            if (node.invisibleAnnotations != null) {
                annotationNodes.addAll(node.invisibleAnnotations);
            }
            return this.shouldApplyPlugin.shouldApplyMixin(targetClassName, mixinClassName, node, annotationNodes);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected final boolean processAnnotations(List<AnnotationNode> nodes, String mixinClassName) {
        if (nodes == null || nodes.isEmpty()) {
            return true;
        }
        boolean load = true;
        for (AnnotationNode node : nodes) {
            Map<String, Object> values;
            if (!SHOULD_APPLY_DESC.equals(node.desc) || (values = ExtendedPlugin.mapAnnotationNode(node)).isEmpty()) continue;
            if (!load || !(load = ExtendedPlugin.checkMods(values))) break;
            load = ExtendedPlugin.checkMCVersion(values);
        }
        return load;
    }

    public static boolean checkMods(Map<String, Object> values) {
        List<Map<String, Object>> array = values.getOrDefault("mods", AsmUtil.emptyAnnotationList());
        if (array.isEmpty()) {
            return true;
        }
        for (int i = 0; i < array.size(); i += 2) {
            Mod.Mode mode;
            String name = (String)array.get(i).get("value");
            if (MOD_PREDICATE.test(name, mode = (Mod.Mode)((Object)array.get(i).getOrDefault("mode", (Object)Mod.Mode.LOADED)))) continue;
            return false;
        }
        return true;
    }

    public static boolean checkMCVersion(Map<String, Object> values) {
        String version = (String)values.getOrDefault("mcVersion", "");
        if (version.isEmpty()) {
            return true;
        }
        try {
            VersionPredicate predicate = VersionPredicate.parse((String)version);
            return predicate.test((Object)MC_VERSION);
        }
        catch (VersionParsingException e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, Object> mapAnnotationNode(AnnotationNode node) {
        return AsmUtil.mapAnnotationNode(node);
    }

    public static Object mapObjectFromAnnotation(Object value) {
        return ExtendedPlugin.mapObjectFromAnnotation(value, true, false);
    }

    public static Object mapObjectFromAnnotation(Object value, boolean loadEnums, boolean loadClasses) {
        return AsmUtil.mapObjectFromAnnotation(value, loadEnums, loadClasses);
    }

    public static Version parseMCVersion() {
        Version version;
        Optional container = FabricLoader.getInstance().getModContainer("minecraft");
        if (container.isPresent() && (version = ((ModContainer)container.get()).getMetadata().getVersion()) instanceof SemanticVersion) {
            return version;
        }
        return null;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
        this.shouldApplyPlugin.afterApply(targetClassName, targetClass, mixinClassName, mixinInfo);
    }
}

