/*
 * Decompiled with CFR 0.152.
 */
package me.melontini.dark_matter.api.base.util.mixin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import me.melontini.dark_matter.api.base.util.mixin.IPluginPlugin;
import me.melontini.dark_matter.impl.base.util.mixin.AsmTransformerPlugin;
import me.melontini.dark_matter.impl.base.util.mixin.ConstructDummyPlugin;
import me.melontini.dark_matter.impl.base.util.mixin.MixinPredicatePlugin;
import me.melontini.dark_matter.impl.base.util.mixin.PublicizePlugin;
import me.melontini.dark_matter.impl.base.util.mixin.ShouldApplyPlugin;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.MappingResolver;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.VersionParsingException;
import net.fabricmc.loader.api.metadata.version.VersionPredicate;
import org.jetbrains.annotations.ApiStatus;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.service.MixinService;

@ApiStatus.Experimental
public class ExtendablePlugin
implements IMixinConfigPlugin {
    private final Set<IPluginPlugin> plugins;

    public ExtendablePlugin() {
        HashSet<IPluginPlugin> plugins = new HashSet<IPluginPlugin>();
        plugins.add(DefaultPlugins.mixinPredicatePlugin());
        this.collectPlugins(plugins);
        this.plugins = Collections.unmodifiableSet(plugins);
    }

    public final void onLoad(String mixinPackage) {
        this.plugins.forEach(plugin -> plugin.onPluginLoad(mixinPackage));
        this.onPluginLoad(mixinPackage);
    }

    public String getRefMapperConfig() {
        return null;
    }

    public final boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        AtomicBoolean apply = new AtomicBoolean(true);
        try {
            ClassNode node = MixinService.getService().getBytecodeProvider().getClassNode(mixinClassName);
            ArrayList<AnnotationNode> annotationNodes = new ArrayList<AnnotationNode>();
            if (node.invisibleAnnotations != null) {
                annotationNodes.addAll(node.invisibleAnnotations);
            }
            if (node.visibleAnnotations != null) {
                annotationNodes.addAll(node.visibleAnnotations);
            }
            for (IPluginPlugin plugin : this.plugins) {
                apply.set(plugin.shouldApplyMixin(targetClassName, mixinClassName, node, annotationNodes));
                if (apply.get()) continue;
                break;
            }
            if (apply.get()) {
                apply.set(this.shouldApplyMixin(targetClassName, mixinClassName, node, annotationNodes));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return apply.get();
    }

    public final void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
        this.plugins.forEach(plugin -> plugin.confirmTargets(myTargets, otherTargets));
        this.confirmTargets(myTargets, otherTargets);
    }

    public final List<String> getMixins() {
        ArrayList<String> mixins = new ArrayList<String>();
        this.plugins.forEach(plugin -> plugin.getMixins(mixins));
        this.getMixins(mixins);
        return mixins.isEmpty() ? null : mixins;
    }

    public final void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
        this.plugins.forEach(plugin -> plugin.beforeApply(targetClassName, targetClass, mixinClassName, mixinInfo));
        this.beforeApply(targetClassName, targetClass, mixinClassName, mixinInfo);
    }

    public final void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
        this.plugins.forEach(plugin -> plugin.afterApply(targetClassName, targetClass, mixinClassName, mixinInfo));
        this.afterApply(targetClassName, targetClass, mixinClassName, mixinInfo);
    }

    @ApiStatus.OverrideOnly
    protected void collectPlugins(Set<IPluginPlugin> plugins) {
    }

    @ApiStatus.OverrideOnly
    protected void onPluginLoad(String mixinPackage) {
    }

    @ApiStatus.OverrideOnly
    protected boolean shouldApplyMixin(String targetClassName, String mixinClassName, ClassNode mixinNode, List<AnnotationNode> mergedAnnotations) {
        return true;
    }

    @ApiStatus.OverrideOnly
    protected void confirmTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    @ApiStatus.OverrideOnly
    protected void getMixins(List<String> mixins) {
    }

    @ApiStatus.OverrideOnly
    protected void beforeApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    @ApiStatus.OverrideOnly
    protected void afterApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    protected boolean isDev() {
        return FabricLoader.getInstance().isDevelopmentEnvironment();
    }

    protected EnvType getEnv() {
        return FabricLoader.getInstance().getEnvironmentType();
    }

    protected boolean isClient() {
        return this.getEnv() == EnvType.CLIENT;
    }

    protected Optional<Version> getModVersion(String modId) {
        return FabricLoader.getInstance().getModContainer(modId).map(m -> m.getMetadata().getVersion());
    }

    protected VersionPredicate asPredicate(String version) {
        try {
            return VersionPredicate.parse((String)version);
        }
        catch (VersionParsingException e) {
            throw new RuntimeException(e);
        }
    }

    protected boolean versionMatches(Version version, VersionPredicate predicate) {
        return predicate.test((Object)version);
    }

    protected MappingResolver getMappingResolver() {
        return FabricLoader.getInstance().getMappingResolver();
    }

    public static final class DefaultPlugins {
        public static IPluginPlugin mixinPredicatePlugin() {
            return new MixinPredicatePlugin();
        }

        @ApiStatus.Obsolete(since="2.0.0")
        public static IPluginPlugin shouldApplyPlugin() {
            return new ShouldApplyPlugin();
        }

        public static IPluginPlugin publicizePlugin() {
            return new PublicizePlugin();
        }

        public static IPluginPlugin asmTransformerPlugin() {
            return new AsmTransformerPlugin();
        }

        @ApiStatus.Experimental
        public static IPluginPlugin constructDummyPlugin() {
            return new ConstructDummyPlugin();
        }
    }
}

