/*
 * Decompiled with CFR 0.152.
 */
package me.melontini.dark_matter.api.base.util.classes;

import java.util.function.Function;

public record Tuple<L, R>(L left, R right) {
    public static <L, R> Tuple<L, R> of(L left, R right) {
        return new Tuple<L, R>(left, right);
    }

    public boolean isLeftPresent() {
        return this.left != null;
    }

    public boolean isRightPresent() {
        return this.right != null;
    }

    public Tuple<R, L> swap() {
        return new Tuple<R, L>(this.right, this.left);
    }

    public <V> Tuple<V, R> mapLeft(Function<? super L, ? extends V> mapper) {
        return new Tuple<V, R>(mapper.apply(this.left), this.right);
    }

    public <V> Tuple<L, V> mapRight(Function<? super R, ? extends V> mapper) {
        return new Tuple<L, V>(this.left, mapper.apply(this.right));
    }

    public <V, V1> Tuple<V, V1> mapBoth(Function<? super L, ? extends V> mapper, Function<? super R, ? extends V1> mapper1) {
        return new Tuple<V, V1>(mapper.apply(this.left), mapper1.apply(this.right));
    }

    @Override
    public String toString() {
        return "Tuple{left=" + this.left + ", right=" + this.right + "}";
    }
}

