/*
 * Decompiled with CFR 0.152.
 */
package me.melontini.dark_matter.api.base.util.classes;

import java.util.Objects;
import java.util.function.Function;

public final class MutableTuple<L, R> {
    private L left;
    private R right;

    public static <L, R> MutableTuple<L, R> of(L left, R right) {
        return new MutableTuple<L, R>(left, right);
    }

    public MutableTuple(L left, R right) {
        this.left = left;
        this.right = right;
    }

    public L left() {
        return this.left;
    }

    public R right() {
        return this.right;
    }

    public void left(L left) {
        this.left = left;
    }

    public void right(R right) {
        this.right = right;
    }

    public boolean isLeftPresent() {
        return this.left != null;
    }

    public boolean isRightPresent() {
        return this.right != null;
    }

    public MutableTuple<R, L> swap() {
        return new MutableTuple<R, L>(this.right, this.left);
    }

    public <V> MutableTuple<V, R> mapLeft(Function<? super L, ? extends V> mapper) {
        return new MutableTuple<V, R>(mapper.apply(this.left), this.right);
    }

    public <V> MutableTuple<L, V> mapRight(Function<? super R, ? extends V> mapper) {
        return new MutableTuple<L, V>(this.left, mapper.apply(this.right));
    }

    public <V, V1> MutableTuple<V, V1> mapBoth(Function<? super L, ? extends V> mapper, Function<? super R, ? extends V1> mapper1) {
        return new MutableTuple<V, V1>(mapper.apply(this.left), mapper1.apply(this.right));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MutableTuple that = (MutableTuple)o;
        return Objects.equals(this.left, that.left) && Objects.equals(this.right, that.right);
    }

    public int hashCode() {
        return Objects.hash(this.left, this.right);
    }

    public String toString() {
        return "MutableTuple{left=" + this.left + ", right=" + this.right + "}";
    }
}

