/*
 * Decompiled with CFR 0.152.
 */
package me.melontini.dark_matter.api.base.util.classes;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;

public interface Context {
    public <T> Optional<T> get(Class<T> var1, String var2);

    public void forEach(BiConsumer<String, Object> var1);

    default public <T> T orThrow(Class<T> cls, String key) {
        return this.get(cls, key).orElseThrow(() -> new IllegalStateException("Missing required context '%s'!".formatted(key)));
    }

    public static Context of() {
        return new Context(){

            @Override
            public <T> Optional<T> get(Class<T> cls, String key) {
                return Optional.empty();
            }

            @Override
            public void forEach(BiConsumer<String, Object> consumer) {
            }

            public String toString() {
                return Collections.emptyMap().toString();
            }
        };
    }

    public static Context of(final Map<String, Object> map) {
        return new Context(){
            private final Map<String, Object> ctx;
            {
                this.ctx = Collections.unmodifiableMap(map);
            }

            @Override
            public <T> Optional<T> get(Class<T> cls, String key) {
                return Optional.ofNullable(cls.cast(this.ctx.get(key)));
            }

            @Override
            public void forEach(BiConsumer<String, Object> consumer) {
                this.ctx.forEach(consumer);
            }

            public String toString() {
                return this.ctx.toString();
            }
        };
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Map<String, Object> map = Collections.synchronizedMap(new HashMap());

        private Builder() {
        }

        public Builder put(String key, Object value) {
            this.map.put(key, value);
            return this;
        }

        public Context build() {
            return Context.of(this.map);
        }
    }
}

