/*
 * Decompiled with CFR 0.152.
 */
package me.melontini.dark_matter.api.base.util;

import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import me.melontini.dark_matter.api.base.util.classes.ThrowingRunnable;
import me.melontini.dark_matter.api.base.util.classes.ThrowingSupplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;

public final class Support {
    public static EnvType environment() {
        return FabricLoader.getInstance().getEnvironmentType();
    }

    public static void run(String modId, Supplier<Runnable> runnable) {
        if (FabricLoader.getInstance().isModLoaded(modId)) {
            runnable.get().run();
        }
    }

    public static <T> Optional<T> get(String modId, Supplier<Supplier<T>> supplier) {
        if (FabricLoader.getInstance().isModLoaded(modId)) {
            return Optional.ofNullable(supplier.get().get());
        }
        return Optional.empty();
    }

    public static <E extends Throwable> void runWeak(String modId, Supplier<ThrowingRunnable<E>> runnable) {
        if (FabricLoader.getInstance().isModLoaded(modId)) {
            try {
                runnable.get().run();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static <T, E extends Throwable> Optional<T> getWeak(String modId, Supplier<ThrowingSupplier<T, E>> supplier) {
        if (FabricLoader.getInstance().isModLoaded(modId)) {
            try {
                return Optional.ofNullable(supplier.get().get());
            }
            catch (Throwable e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    public static void run(EnvType envType, Supplier<Runnable> runnable) {
        if (Support.environment() == envType) {
            runnable.get().run();
        }
    }

    public static <T> Optional<T> get(EnvType envType, Supplier<Supplier<T>> supplier) {
        if (Support.environment() == envType) {
            return Optional.ofNullable(supplier.get().get());
        }
        return Optional.empty();
    }

    public static <E extends Throwable> void runWeak(EnvType envType, Supplier<ThrowingRunnable<E>> runnable) {
        if (Support.environment() == envType) {
            try {
                runnable.get().run();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static <T, E extends Throwable> Optional<T> getWeak(EnvType envType, Supplier<ThrowingSupplier<T, E>> supplier) {
        if (Support.environment() == envType) {
            try {
                return Optional.ofNullable(supplier.get().get());
            }
            catch (Throwable e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    public static void runEnv(Supplier<Runnable> clientRunnable, Supplier<Runnable> serverRunnable) {
        if (Support.environment() == EnvType.CLIENT) {
            clientRunnable.get().run();
        } else {
            serverRunnable.get().run();
        }
    }

    public static <T> Optional<T> getEnv(Supplier<Supplier<T>> clientSupplier, Supplier<Supplier<T>> serverSupplier) {
        if (Support.environment() == EnvType.CLIENT) {
            return Optional.ofNullable(clientSupplier.get().get());
        }
        return Optional.ofNullable(serverSupplier.get().get());
    }

    public static <E extends Throwable> void runEnvWeak(Supplier<ThrowingRunnable<E>> clientRunnable, Supplier<ThrowingRunnable<E>> serverRunnable) {
        try {
            if (Support.environment() == EnvType.CLIENT) {
                clientRunnable.get().run();
            } else {
                serverRunnable.get().run();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static <T, E extends Throwable> Optional<T> getEnvWeak(Supplier<ThrowingSupplier<T, E>> clientSupplier, Supplier<ThrowingSupplier<T, E>> serverSupplier) {
        try {
            if (Support.environment() == EnvType.CLIENT) {
                return Optional.ofNullable(clientSupplier.get().get());
            }
            return Optional.ofNullable(serverSupplier.get().get());
        }
        catch (Throwable e) {
            return Optional.empty();
        }
    }

    public static void share(String id, Object o) {
        FabricLoader.getInstance().getObjectShare().put(id, o);
    }

    public static <T> void whenAvailable(String id, Class<T> type, BiConsumer<String, T> consumer) {
        FabricLoader.getInstance().getObjectShare().whenAvailable(id, (s, o) -> {
            if (type.isInstance(o)) {
                consumer.accept((String)s, type.cast(o));
            }
        });
    }

    public static <T> void whenAvailable(EnvType envType, String id, Class<T> type, BiConsumer<String, T> consumer) {
        if (Support.environment() == envType) {
            FabricLoader.getInstance().getObjectShare().whenAvailable(id, (s, o) -> {
                if (type.isInstance(o)) {
                    consumer.accept((String)s, type.cast(o));
                }
            });
        }
    }

    private Support() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

