/*
 * Decompiled with CFR 0.152.
 */
package me.melontini.dark_matter.api.base.util;

import java.util.function.Function;
import me.melontini.dark_matter.api.base.util.Utilities;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PrependingLogger {
    public static final Function<Logger, String> LOGGER_NAME = PrependingLogger::getNameOrEmpty;
    public static final Function<Logger, String> METHOD_CALLER = logger -> {
        String[] caller = Utilities.getCallerName(3).split("\\.");
        return "[" + caller[caller.length - 1] + "] ";
    };
    public static final Function<Logger, String> METHOD_CALLER_WRAPPED = logger -> {
        String[] caller = Utilities.getCallerName(4).split("\\.");
        return "[" + caller[caller.length - 1] + "] ";
    };
    public static final Function<Logger, String> NAME_METHOD_MIX = logger -> {
        String[] caller = Utilities.getCallerName(3).split("\\.");
        return PrependingLogger.getNameOrEmpty(logger) + "[" + caller[caller.length - 1] + "] ";
    };
    public static final Function<Logger, String> NAME_METHOD_MIX_WRAPPED = logger -> {
        String[] caller = Utilities.getCallerName(4).split("\\.");
        return PrependingLogger.getNameOrEmpty(logger) + "[" + caller[caller.length - 1] + "] ";
    };
    public static final Function<Logger, String> CALLING_CLASS = logger -> {
        String[] cls = Utilities.getCallerClass(3).getName().split("\\.");
        return "[" + cls[cls.length - 1] + "] ";
    };
    public static final Function<Logger, String> CALLING_CLASS_WRAPPED = logger -> {
        String[] cls = Utilities.getCallerClass(4).getName().split("\\.");
        return "[" + cls[cls.length - 1] + "] ";
    };
    public static final Function<Logger, String> NAME_CLASS_MIX = logger -> {
        String[] cls = Utilities.getCallerClass(3).getName().split("\\.");
        return PrependingLogger.getNameOrEmpty(logger) + "[" + cls[cls.length - 1] + "] ";
    };
    public static final Function<Logger, String> NAME_CLASS_MIX_WRAPPED = logger -> {
        String[] cls = Utilities.getCallerClass(4).getName().split("\\.");
        return PrependingLogger.getNameOrEmpty(logger) + "[" + cls[cls.length - 1] + "] ";
    };
    private static final Function<Logger, String> DEFAULT = logger -> "";
    private final Logger backing;
    protected volatile Function<Logger, String> prefixGetter = DEFAULT;

    public PrependingLogger(Logger backing, Function<Logger, String> prefixGetter) {
        this.backing = backing;
        this.prefixGetter = prefixGetter;
    }

    public PrependingLogger(Logger backing) {
        this.backing = backing;
    }

    public static PrependingLogger get() {
        String[] cls = Utilities.getCallerClass(2).getName().split("\\.");
        return new PrependingLogger(LogManager.getLogger((String)cls[cls.length - 1]), LOGGER_NAME);
    }

    public static PrependingLogger get(String name) {
        return new PrependingLogger(LogManager.getLogger((String)name), LOGGER_NAME);
    }

    public static PrependingLogger get(String name, Function<Logger, String> prefixGetter) {
        return new PrependingLogger(LogManager.getLogger((String)name), prefixGetter);
    }

    public static PrependingLogger withClass(String name) {
        return new PrependingLogger(LogManager.getLogger((String)name), NAME_CLASS_MIX);
    }

    public static PrependingLogger withMethod(String name) {
        return new PrependingLogger(LogManager.getLogger((String)name), NAME_METHOD_MIX);
    }

    private static String getNameOrEmpty(Logger logger) {
        return !Utilities.isDev() ? "(" + logger.getName() + ") " : "";
    }

    public void fatal(String msg) {
        this.backing.fatal(this.prefixGetter.apply(this.backing) + msg);
    }

    public void fatal(String msg, Throwable t) {
        this.backing.fatal(this.prefixGetter.apply(this.backing) + msg, t);
    }

    public void fatal(Throwable msg) {
        this.backing.fatal(this.prefixGetter.apply(this.backing), msg);
    }

    public void fatal(Object msg) {
        this.backing.fatal(this.prefixGetter.apply(this.backing) + "{}", msg);
    }

    public void fatal(String msg, Object ... args) {
        this.backing.fatal(this.prefixGetter.apply(this.backing) + msg, args);
    }

    public void error(String msg) {
        this.backing.error(this.prefixGetter.apply(this.backing) + msg);
    }

    public void error(String msg, Throwable t) {
        this.backing.error(this.prefixGetter.apply(this.backing) + msg, t);
    }

    public void error(Throwable msg) {
        this.backing.error(this.prefixGetter.apply(this.backing), msg);
    }

    public void error(Object msg) {
        this.backing.error(this.prefixGetter.apply(this.backing) + "{}", msg);
    }

    public void error(String msg, Object ... args) {
        this.backing.error(this.prefixGetter.apply(this.backing) + msg, args);
    }

    public void warn(String msg) {
        this.backing.warn(this.prefixGetter.apply(this.backing) + msg);
    }

    public void warn(String msg, Throwable t) {
        this.backing.warn(this.prefixGetter.apply(this.backing) + msg, t);
    }

    public void warn(Throwable msg) {
        this.backing.warn(this.prefixGetter.apply(this.backing), msg);
    }

    public void warn(Object msg) {
        this.backing.warn(this.prefixGetter.apply(this.backing) + "{}", msg);
    }

    public void warn(String msg, Object ... args) {
        this.backing.warn(this.prefixGetter.apply(this.backing) + msg, args);
    }

    public void info(String msg) {
        this.backing.info(this.prefixGetter.apply(this.backing) + msg);
    }

    public void info(String msg, Throwable t) {
        this.backing.info(this.prefixGetter.apply(this.backing) + msg, t);
    }

    public void info(Throwable msg) {
        this.backing.info(this.prefixGetter.apply(this.backing), msg);
    }

    public void info(Object msg) {
        this.backing.info(this.prefixGetter.apply(this.backing) + "{}", msg);
    }

    public void info(String msg, Object ... args) {
        this.backing.info(this.prefixGetter.apply(this.backing) + msg, args);
    }

    public void debug(String msg) {
        this.backing.debug(this.prefixGetter.apply(this.backing) + msg);
    }

    public void debug(String msg, Throwable t) {
        this.backing.debug(this.prefixGetter.apply(this.backing) + msg, t);
    }

    public void debug(Throwable msg) {
        this.backing.debug(this.prefixGetter.apply(this.backing), msg);
    }

    public void debug(Object msg) {
        this.backing.debug(this.prefixGetter.apply(this.backing) + "{}", msg);
    }

    public void debug(String msg, Object ... args) {
        this.backing.debug(this.prefixGetter.apply(this.backing) + msg, args);
    }

    public void trace(String msg) {
        this.backing.trace(this.prefixGetter.apply(this.backing) + msg);
    }

    public void trace(String msg, Throwable t) {
        this.backing.trace(this.prefixGetter.apply(this.backing) + msg, t);
    }

    public void trace(Throwable msg) {
        this.backing.trace(this.prefixGetter.apply(this.backing), msg);
    }

    public void trace(Object msg) {
        this.backing.trace(this.prefixGetter.apply(this.backing) + "{}", msg);
    }

    public void trace(String msg, Object ... args) {
        this.backing.trace(this.prefixGetter.apply(this.backing) + msg, args);
    }

    public Logger getBacking() {
        return this.backing;
    }
}

