/*
 * Decompiled with CFR 0.152.
 */
package me.melontini.dark_matter.api.base.reflect.wrappers;

import java.lang.invoke.MethodHandle;
import java.lang.reflect.Method;
import java.util.Arrays;
import me.melontini.dark_matter.api.base.reflect.MiscReflection;
import me.melontini.dark_matter.api.base.reflect.Reflect;
import me.melontini.dark_matter.api.base.util.Utilities;

public interface GenericMethod<O, R> {
    public R invoke(O var1, Object ... var2);

    public GenericMethod<O, R> accessible(boolean var1);

    public static <O, R> GenericMethod<O, R> of(Class<O> cls, String name, Class<?> ... args) {
        return Reflect.findMethod(cls, name, args).map(GenericMethod::of).orElseThrow(() -> new IllegalStateException("No such method %s.%s(%s)!".formatted(cls, name, Arrays.toString(args))));
    }

    public static <O, R> GenericMethod<O, R> of(final Method method) {
        return new GenericMethod<O, R>(){

            @Override
            public R invoke(O obj, Object ... args) {
                return Utilities.supplyUnchecked(() -> method.invoke(obj, args));
            }

            @Override
            public GenericMethod<O, R> accessible(boolean accessible) {
                method.setAccessible(accessible);
                return this;
            }
        };
    }

    public static <O, R> GenericMethod<O, R> ofTrusted(Class<O> cls, String name, Class<?> ... args) {
        return Reflect.findMethod(cls, name, args).map(GenericMethod::ofTrusted).orElseThrow(() -> new IllegalStateException("No such method %s.%s(%s)!".formatted(cls, name, Arrays.toString(args))));
    }

    public static <O, R> GenericMethod<O, R> ofTrusted(Method method) {
        final MethodHandle handle = Utilities.supplyUnchecked(() -> MiscReflection.lookupIn(method.getDeclaringClass()).unreflect(method));
        return new GenericMethod<O, R>(){

            @Override
            public R invoke(O obj, Object ... args) {
                if (obj == null) {
                    return Utilities.supplyUnchecked(() -> handle.invoke(args));
                }
                return Utilities.supplyUnchecked(() -> handle.invoke(obj, args));
            }

            @Override
            public GenericMethod<O, R> accessible(boolean accessible) {
                return this;
            }
        };
    }
}

