/*
 * Decompiled with CFR 0.152.
 */
package me.melontini.dark_matter.api.base.reflect.wrappers;

import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Field;
import me.melontini.dark_matter.api.base.reflect.MiscReflection;
import me.melontini.dark_matter.api.base.reflect.Reflect;
import me.melontini.dark_matter.api.base.util.Utilities;
import me.melontini.dark_matter.api.base.util.classes.ThrowingSupplier;

public interface GenericField<O, T> {
    public T get(O var1);

    public void set(O var1, T var2);

    public GenericField<O, T> accessible(boolean var1);

    public static <O, T> GenericField<O, T> of(Class<O> cls, String name) {
        return Reflect.findField(cls, name).map(GenericField::of).orElseThrow(() -> new IllegalStateException("No such field %s.%s!".formatted(cls, name)));
    }

    public static <O, T> GenericField<O, T> of(final Field field) {
        return new GenericField<O, T>(){

            @Override
            public T get(O obj) {
                return Utilities.supplyUnchecked(() -> field.get(obj));
            }

            @Override
            public void set(O obj, T value) {
                Utilities.runUnchecked(() -> field.set(obj, value));
            }

            @Override
            public GenericField<O, T> accessible(boolean accessible) {
                field.setAccessible(accessible);
                return this;
            }
        };
    }

    public static <O, T> GenericField<O, T> ofTrusted(Class<O> cls, String name) {
        return Reflect.findField(cls, name).map(GenericField::ofTrusted).orElseThrow(() -> new IllegalStateException("No such field %s.%s!".formatted(cls, name)));
    }

    public static <O, T> GenericField<O, T> ofTrusted(Field field) {
        final VarHandle handle = Utilities.supplyUnchecked(() -> MiscReflection.unreflectVarHandle(field));
        return new GenericField<O, T>(){

            @Override
            public T get(O obj) {
                if (obj == null) {
                    return Utilities.supplyUnchecked((ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, get(), ()Ljava/lang/Object;)((VarHandle)handle));
                }
                return Utilities.supplyUnchecked(() -> handle.get(obj));
            }

            @Override
            public void set(O obj, T value) {
                if (obj == null) {
                    Utilities.runUnchecked(() -> handle.set(value));
                } else {
                    Utilities.runUnchecked(() -> handle.set(obj, value));
                }
            }

            @Override
            public GenericField<O, T> accessible(boolean accessible) {
                return this;
            }
        };
    }
}

