/*
 * Decompiled with CFR 0.152.
 */
package me.melontini.dark_matter.api.base.reflect.wrappers;

import java.lang.invoke.MethodHandle;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import me.melontini.dark_matter.api.base.reflect.MiscReflection;
import me.melontini.dark_matter.api.base.reflect.Reflect;
import me.melontini.dark_matter.api.base.util.Utilities;

public interface GenericConstructor<O> {
    public O construct(Object ... var1);

    public GenericConstructor<O> accessible(boolean var1);

    public static <O> GenericConstructor<O> of(Class<O> cls, Class<?> ... args) {
        return Reflect.findConstructor(cls, args).map(GenericConstructor::of).orElseThrow(() -> new IllegalStateException("No such constructor %s(%s)!".formatted(cls, Arrays.toString(args))));
    }

    public static <O> GenericConstructor<O> of(final Constructor<O> ctx) {
        return new GenericConstructor<O>(){

            @Override
            public O construct(Object ... args) {
                return Utilities.supplyUnchecked(() -> ctx.newInstance(args));
            }

            @Override
            public GenericConstructor<O> accessible(boolean accessible) {
                ctx.setAccessible(accessible);
                return this;
            }
        };
    }

    public static <O> GenericConstructor<O> ofTrusted(Class<O> cls, Class<?> ... args) {
        return Reflect.findConstructor(cls, args).map(GenericConstructor::ofTrusted).orElseThrow(() -> new IllegalStateException("No such constructor %s(%s)!".formatted(cls, Arrays.toString(args))));
    }

    public static <O> GenericConstructor<O> ofTrusted(Constructor<O> ctx) {
        final MethodHandle handle = Utilities.supplyUnchecked(() -> MiscReflection.lookupIn(ctx.getDeclaringClass()).unreflectConstructor(ctx));
        return new GenericConstructor<O>(){

            @Override
            public O construct(Object ... args) {
                return Utilities.supplyUnchecked(() -> handle.invoke(args));
            }

            @Override
            public GenericConstructor<O> accessible(boolean accessible) {
                return this;
            }
        };
    }
}

