/*
 * Decompiled with CFR 0.152.
 */
package me.melontini.dark_matter.api.base.config;

import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.melontini.dark_matter.impl.base.config.ConfigManagerImpl;

public interface ConfigManager<T> {
    public static <T> ConfigManager<T> of(Class<T> type, String name) {
        return new ConfigManagerImpl<Object>(type, name, () -> {
            try {
                return type.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to construct %s".formatted(type.getName()), e);
            }
        });
    }

    public static <T> ConfigManager<T> of(Class<T> type, String name, Supplier<T> constructor) {
        return new ConfigManagerImpl<T>(type, name, constructor);
    }

    public ConfigManager<T> fixup(Consumer<JsonObject> var1);

    public T createDefault();

    public T load(Path var1);

    public void save(Path var1, T var2);

    public Path resolve(Path var1);

    public ConfigManager<T> onSave(Listener<T> var1);

    public ConfigManager<T> onLoad(Listener<T> var1);

    public ConfigManager<T> exceptionHandler(Handler var1);

    public Class<T> type();

    public String name();

    public static enum Stage {
        SAVE,
        LOAD;

    }

    public static interface Handler {
        public void accept(Exception var1, Stage var2, Path var3);
    }

    public static interface Listener<T> {
        public void accept(T var1, Path var2);
    }
}

