/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.config.impl.ui.tiny.entry;

import io.gitlab.jfronny.libjf.config.impl.ui.tiny.entry.Reflowable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_6379;
import net.minecraft.class_8030;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class EntryListWidget
extends class_4265<ConfigEntry> {
    private final class_327 textRenderer;
    private final boolean background;

    public EntryListWidget(class_310 client, class_327 tr, int width, int height, int top, int bottom) {
        super(client, width, height, top, bottom, 25);
        this.field_22744 = false;
        this.textRenderer = tr;
        this.background = client.field_1687 == null;
        this.method_31322(this.background);
        this.method_31323(this.background);
    }

    public int method_25329() {
        return this.field_22742 - 7;
    }

    public void addUnknown(class_339 resetButton, BooleanSupplier resetVisible, class_2561 text, Reflowable reflow) {
        this.method_25321((class_350.class_351)new ConfigUnknownEntry(text, resetVisible, resetButton, reflow));
    }

    public void addButton(@Nullable class_339 button, class_339 resetButton, BooleanSupplier resetVisible, class_2561 text, Reflowable reflow) {
        this.method_25321((class_350.class_351)new ConfigScreenEntry(button, text, resetVisible, resetButton, reflow));
    }

    public void addReference(class_2561 text, Supplier<class_437> targetScreen) {
        this.method_25321((class_350.class_351)new ConfigReferenceEntry(this.field_22742, text, targetScreen));
    }

    public void addText(class_2561 text) {
        for (ConfigEntry configEntry : ConfigTextEntry.create(this, (class_5348)text, this.field_22742)) {
            this.method_25321((class_350.class_351)configEntry);
        }
    }

    public int method_25322() {
        return 10000;
    }

    public Optional<class_2561> getHoveredEntryTitle(double mouseY) {
        for (ConfigEntry abstractEntry : this.method_25396()) {
            if (abstractEntry instanceof ConfigScreenEntry) {
                ConfigScreenEntry entry = (ConfigScreenEntry)abstractEntry;
                if (entry.button.field_22764 && mouseY >= (double)entry.button.method_46427() && mouseY < (double)(entry.button.method_46427() + this.field_22741)) {
                    return Optional.of(entry.getText());
                }
            }
            if (!(abstractEntry instanceof ConfigUnknownEntry)) continue;
            ConfigUnknownEntry entry = (ConfigUnknownEntry)abstractEntry;
            if (!(mouseY >= (double)entry.resetButton.method_46427()) || !(mouseY < (double)(entry.resetButton.method_46427() + this.field_22741))) continue;
            return Optional.of(entry.getText());
        }
        return Optional.empty();
    }

    public void refreshGrid(class_8030 tabArea) {
        int len;
        this.method_25323(tabArea.comp_1196(), tabArea.comp_1197(), tabArea.method_49618(), tabArea.method_49619());
        this.method_25333(tabArea.method_49620());
        for (int i = len = this.method_25340() - 1; i >= 0; --i) {
            ((ConfigEntry)this.method_25326(i)).reflow(this.field_22742, this.field_22743);
        }
    }

    protected void method_25320(class_332 context, int mouseX, int mouseY) {
        super.method_25320(context, mouseX, mouseY);
        if (this.background) {
            return;
        }
        context.method_51422(0.25f, 0.25f, 0.25f, 1.0f);
        context.method_25290(class_437.field_44669, this.field_19088, 0, 0.0f, 0.0f, this.field_22742, this.field_19085, 32, 32);
        context.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        context.method_51740(class_1921.method_51785(), this.field_19088, this.field_19085, this.field_19087, this.field_19085 + 4, -16777216, 0, 0);
        if (this.method_25341() < (double)this.method_25331()) {
            context.method_51740(class_1921.method_51785(), this.field_19088, this.field_19086 - 4, this.field_19087, this.field_19086, 0, -16777216, 0);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class ConfigUnknownEntry
    extends ConfigEntry {
        private static final class_327 textRenderer = class_310.method_1551().field_1772;
        private final BooleanSupplier resetVisible;
        private final class_339 resetButton;
        private final class_2561 text;
        private final Reflowable reflow;

        public ConfigUnknownEntry(class_2561 text, BooleanSupplier resetVisible, class_339 resetButton, Reflowable reflow) {
            this.resetVisible = resetVisible;
            this.resetButton = resetButton;
            this.text = text;
            this.reflow = reflow;
        }

        @Override
        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            super.method_25343(context, index, y, x, entryWidth, entryHeight, mouseX, mouseY, hovered, tickDelta);
            context.method_27535(textRenderer, this.text, 12, y + 5, 0xFFFFFF);
            if (this.resetVisible.getAsBoolean()) {
                this.resetButton.method_46419(y);
                this.resetButton.method_25394(context, mouseX, mouseY, tickDelta);
            }
        }

        @Override
        public void reflow(int width, int height) {
            this.reflow.reflow(width, height);
        }

        public List<? extends class_364> method_25396() {
            return List.of(this.resetButton);
        }

        public List<? extends class_6379> method_37025() {
            return List.of();
        }

        public class_2561 getText() {
            return this.text;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class ConfigScreenEntry
    extends ConfigEntry {
        private static final class_327 textRenderer = class_310.method_1551().field_1772;
        public final class_339 button;
        private final BooleanSupplier resetVisible;
        private final class_339 resetButton;
        private final class_2561 text;
        private final Reflowable reflow;

        public ConfigScreenEntry(class_339 button, class_2561 text, BooleanSupplier resetVisible, class_339 resetButton, Reflowable reflow) {
            this.button = button;
            this.resetVisible = resetVisible;
            this.resetButton = resetButton;
            this.text = text;
            this.reflow = reflow;
        }

        @Override
        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            super.method_25343(context, index, y, x, entryWidth, entryHeight, mouseX, mouseY, hovered, tickDelta);
            this.button.method_46419(y);
            this.button.method_25394(context, mouseX, mouseY, tickDelta);
            context.method_27535(textRenderer, this.text, 12, y + 5, 0xFFFFFF);
            if (this.resetVisible.getAsBoolean()) {
                this.resetButton.method_46419(y);
                this.resetButton.method_25394(context, mouseX, mouseY, tickDelta);
            }
        }

        @Override
        public void reflow(int width, int height) {
            this.reflow.reflow(width, height);
        }

        public List<? extends class_364> method_25396() {
            return List.of(this.button, this.resetButton);
        }

        public List<? extends class_6379> method_37025() {
            return List.of(this.button);
        }

        public class_2561 getText() {
            return this.text;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class ConfigReferenceEntry
    extends ConfigEntry {
        private final class_339 button;

        public ConfigReferenceEntry(int width, class_2561 text, Supplier<class_437> targetScreen) {
            this.button = class_4185.method_46430((class_2561)text, btn -> class_310.method_1551().method_1507((class_437)targetScreen.get())).method_46434(width / 2 - 154, 0, 308, 20).method_46431();
        }

        public List<? extends class_6379> method_37025() {
            return List.of(this.button);
        }

        public List<? extends class_364> method_25396() {
            return List.of(this.button);
        }

        @Override
        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            super.method_25343(context, index, y, x, entryWidth, entryHeight, mouseX, mouseY, hovered, tickDelta);
            this.button.method_46419(y);
            this.button.method_25394(context, mouseX, mouseY, tickDelta);
        }

        @Override
        public void reflow(int width, int height) {
            this.button.method_46421(width / 2 - 154);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public class ConfigTextEntry
    extends ConfigEntry {
        private int width;
        private final class_5481 text;
        private final class_327 renderer;
        private final ConfigTextEntry next;
        public class_5348 originalText = null;

        public ConfigTextEntry(int width, class_5481 text, class_327 renderer, ConfigTextEntry next) {
            this.width = width;
            this.text = text;
            this.renderer = renderer;
            this.next = next;
        }

        public static List<ConfigTextEntry> create(EntryListWidget parent, class_5348 text, int width) {
            class_327 renderer = class_310.method_1551().field_1772;
            ArrayList<ConfigTextEntry> entries = new ArrayList<ConfigTextEntry>();
            ConfigTextEntry next = null;
            ArrayList wrappedLines = new ArrayList(renderer.method_1728(text, width));
            Collections.reverse(wrappedLines);
            for (class_5481 line : wrappedLines) {
                ConfigTextEntry[] tmp = new ConfigTextEntry[1];
                EntryListWidget entryListWidget = parent;
                Objects.requireNonNull(entryListWidget);
                next = tmp[0] = entryListWidget.new ConfigTextEntry(width, line, renderer, next);
                entries.add(tmp[0]);
            }
            if (!entries.isEmpty()) {
                ((ConfigTextEntry)entries.get((int)(entries.size() - 1))).originalText = text;
            }
            Collections.reverse(entries);
            return entries;
        }

        public List<? extends class_6379> method_37025() {
            return List.of();
        }

        public List<? extends class_364> method_25396() {
            return List.of();
        }

        @Override
        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            super.method_25343(context, index, y, x, entryWidth, entryHeight, mouseX, mouseY, hovered, tickDelta);
            int textX = (this.width - this.renderer.method_30880(this.text)) / 2;
            Objects.requireNonNull(this.renderer);
            int textY = y + (20 - 9) / 2;
            context.method_35720(this.renderer, this.text, textX, textY, 0xFFFFFF);
        }

        @Override
        public void reflow(int width, int height) {
            this.width = width;
            if (this.originalText != null) {
                List children = EntryListWidget.this.method_25396();
                int i = children.indexOf(this);
                EntryListWidget.this.method_25330((class_350.class_351)this);
                for (ConfigTextEntry entry : ConfigTextEntry.create(EntryListWidget.this, this.originalText, width)) {
                    children.add(i++, entry);
                }
            } else {
                EntryListWidget.this.method_25330((class_350.class_351)this);
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static abstract class ConfigEntry
    extends class_4265.class_4266<ConfigEntry>
    implements Reflowable {
        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            if (hovered) {
                context.method_25294(x, y, x + entryWidth, y + entryHeight, 0x24FFFFFF);
            }
        }
    }
}

