/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.config.impl.ui.tiny.entry;

import io.gitlab.jfronny.commons.ref.R;
import io.gitlab.jfronny.commons.serialize.gson.api.v1.GsonHolders;
import io.gitlab.jfronny.commons.throwable.Try;
import io.gitlab.jfronny.libjf.LibJf;
import io.gitlab.jfronny.libjf.config.api.v1.ConfigCategory;
import io.gitlab.jfronny.libjf.config.api.v1.EntryInfo;
import io.gitlab.jfronny.libjf.config.api.v1.type.Type;
import io.gitlab.jfronny.libjf.config.api.v1.ui.tiny.WidgetFactory;
import io.gitlab.jfronny.libjf.config.impl.ui.tiny.EditorScreen;
import io.gitlab.jfronny.libjf.config.impl.ui.tiny.entry.CustomSlider;
import io.gitlab.jfronny.libjf.config.impl.ui.tiny.entry.WidgetState;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_370;
import net.minecraft.class_374;
import net.minecraft.class_4185;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class EntryInfoWidgetBuilder {
    private static final Pattern INTEGER_ONLY = Pattern.compile("(-?\\d*)");
    private static final Pattern DECIMAL_ONLY = Pattern.compile("-?(\\d+\\.?\\d*|\\d*\\.?\\d+|\\.)");

    public static List<WidgetState<?>> buildWidgets(ConfigCategory config, List<WidgetState<?>> knownStates) {
        LinkedList knownStates2 = new LinkedList();
        for (EntryInfo info : config.getEntries()) {
            WidgetState state = EntryInfoWidgetBuilder.initEntry(config, info, knownStates);
            knownStates.add(state);
            knownStates2.add(state);
        }
        return knownStates2;
    }

    private static <T> WidgetState<T> initEntry(ConfigCategory config, EntryInfo<T> info, List<WidgetState<?>> knownStates) {
        WidgetFactory<Object> factory;
        Type type = info.getValueType();
        WidgetState state = new WidgetState();
        if (type.isInt()) {
            factory = EntryInfoWidgetBuilder.isDiscrete(info) ? EntryInfoWidgetBuilder.slider(info, state, t -> (double)t, Double::intValue, true) : EntryInfoWidgetBuilder.textField(info, state, INTEGER_ONLY, Integer::parseInt, true, info.getMinValue(), info.getMaxValue());
        } else if (type.isLong()) {
            factory = EntryInfoWidgetBuilder.isDiscrete(info) ? EntryInfoWidgetBuilder.slider(info, state, t -> (double)t, Double::longValue, true) : EntryInfoWidgetBuilder.textField(info, state, INTEGER_ONLY, Long::parseLong, true, info.getMinValue(), info.getMaxValue());
        } else if (type.isFloat()) {
            factory = EntryInfoWidgetBuilder.isDiscrete(info) ? EntryInfoWidgetBuilder.slider(info, state, t -> t.floatValue(), Double::floatValue, false) : EntryInfoWidgetBuilder.textField(info, state, DECIMAL_ONLY, Float::parseFloat, false, info.getMinValue(), info.getMaxValue());
        } else if (type.isDouble()) {
            factory = EntryInfoWidgetBuilder.isDiscrete(info) ? EntryInfoWidgetBuilder.slider(info, state, t -> t, t -> t, false) : EntryInfoWidgetBuilder.textField(info, state, DECIMAL_ONLY, Double::parseDouble, false, info.getMinValue(), info.getMaxValue());
        } else if (type.isString()) {
            factory = EntryInfoWidgetBuilder.textField(info, state, null, String::length, true, Math.min(info.getMinValue(), 0.0), Math.max(info.getMaxValue(), 1.0));
        } else if (type.isBool()) {
            factory = EntryInfoWidgetBuilder.toggle(info, state, value -> value == false, value -> class_2561.method_43470((String)(value != false ? "True" : "False")).method_27692(value != false ? class_124.field_1060 : class_124.field_1061));
        } else if (type.isEnum()) {
            Object[] values = type.asEnum().options();
            factory = EntryInfoWidgetBuilder.toggle(info, state, value -> {
                int index = EntryInfoWidgetBuilder.indexOf(values, value) + 1;
                return values[index >= values.length ? 0 : index];
            }, value -> {
                if (type.asClass() == null) {
                    return class_2561.method_43471((String)(config.getTranslationPrefix() + info.getName() + "." + state.cachedValue));
                }
                return class_2561.method_43471((String)(config.getTranslationPrefix() + "enum." + type.getName() + "." + state.cachedValue));
            });
        } else {
            LibJf.LOGGER.error("Unsupported entry type in " + info.getName() + ": " + type.getName() + " - displaying fallback");
            factory = EntryInfoWidgetBuilder.jsonScreen(config, info, state);
        }
        Try.orThrow(() -> state.initialize(info, knownStates, factory, config.getTranslationPrefix()));
        return state;
    }

    private static int indexOf(Object[] array, Object value) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != value) continue;
            return i;
        }
        return -1;
    }

    private static <T> WidgetFactory<T> toggle(EntryInfo<T> info, WidgetState<T> state, UnaryOperator<T> increment, Function<T, class_2561> valueToText) {
        return (screen, textRenderer) -> {
            class_4185 button = class_4185.method_46430((class_2561)((class_2561)valueToText.apply(state.cachedValue)), btn -> {
                state.updateCache(increment.apply(state.cachedValue));
                btn.method_25355((class_2561)valueToText.apply(state.cachedValue));
            }).method_46434(screen.field_22789 - 110, 0, info.getWidth(), 20).method_46431();
            return new WidgetFactory.Widget<Object>(state, value -> button.method_25355((class_2561)valueToText.apply(value)), (class_339)button, (width, height) -> button.method_46421(width - 110));
        };
    }

    private static <T> WidgetFactory<T> textField(EntryInfo<T> info, WidgetState<T> state, Pattern pattern, Function<String, Number> sizeFetcher, boolean wholeNumber, double min, double max) {
        boolean isNumber = pattern != null;
        return (screen, textRenderer) -> {
            class_342 widget = new class_342(textRenderer, screen.field_22789 - 110, 0, info.getWidth(), 20, null);
            widget.method_1852(state.tempValue);
            widget.method_1890(currentInput -> {
                if (!(currentInput = currentInput.trim()).isEmpty() && isNumber && !pattern.matcher((CharSequence)currentInput).matches()) {
                    return false;
                }
                Number value = 0;
                boolean inLimits = false;
                state.error = null;
                if (!(isNumber && currentInput.isEmpty() || currentInput.equals("-") || currentInput.equals("."))) {
                    value = (Number)sizeFetcher.apply((String)currentInput);
                    boolean bl = inLimits = value.doubleValue() >= min && value.doubleValue() <= max;
                    state.error = inLimits ? null : class_2561.method_43470((String)(value.doubleValue() < min ? "\u00a7cMinimum " + (isNumber ? "value" : "length") + (wholeNumber ? " is " + (int)min : " is " + min) : "\u00a7cMaximum " + (isNumber ? "value" : "length") + (wholeNumber ? " is " + (int)max : " is " + max))).method_27692(class_124.field_1061);
                }
                state.tempValue = currentInput;
                widget.method_1868(inLimits ? -1 : -34953);
                state.inLimits = inLimits;
                screen.done.field_22763 = state.knownStates.stream().allMatch(st -> st.inLimits);
                if (inLimits) {
                    state.cachedValue = isNumber ? value : currentInput;
                }
                return true;
            });
            return new WidgetFactory.Widget<Object>(state, value -> widget.method_1852(value == null ? "" : value.toString()), (class_339)widget, (width, height) -> widget.method_46421(width - 110));
        };
    }

    private static <T> WidgetFactory<T> jsonScreen(ConfigCategory config, EntryInfo<T> info, WidgetState<T> state) {
        state.managedTemp = false;
        state.tempValue = null;
        return (screen, textRenderer) -> {
            class_4185 button = class_4185.method_46430((class_2561)class_2561.method_43471((String)"libjf-config-core-v1.edit"), $ -> {
                String jsonified;
                if (state.tempValue == null) {
                    try {
                        jsonified = GsonHolders.CONFIG.getGson().toJson(state.cachedValue);
                    }
                    catch (Throwable e) {
                        LibJf.LOGGER.error("Could not stringify element", e);
                        class_370.method_27024((class_374)screen.getClient().method_1566(), (class_370.class_371)class_370.class_371.field_21809, (class_2561)class_2561.method_43471((String)"libjf-config-ui-tiny-v1.entry.json.read.fail.title"), (class_2561)class_2561.method_43471((String)"libjf-config-ui-tiny-v1.entry.json.read.fail.description"));
                        return;
                    }
                } else {
                    jsonified = state.tempValue;
                }
                String key = config.getTranslationPrefix() + info.getName();
                screen.getClient().method_1507((class_437)new EditorScreen((class_2561)class_2561.method_43471((String)key), (class_2561)(class_1074.method_4663((String)(key + ".tooltip")) ? class_2561.method_43471((String)(key + ".tooltip")) : null), screen, jsonified, json -> {
                    try {
                        state.updateCache(GsonHolders.CONFIG.getGson().fromJson(json, info.getValueType().asClass()));
                        state.tempValue = null;
                    }
                    catch (Throwable e) {
                        LibJf.LOGGER.error("Could not write element", e);
                        class_370.method_27024((class_374)screen.getClient().method_1566(), (class_370.class_371)class_370.class_371.field_21809, (class_2561)class_2561.method_43471((String)"libjf-config-ui-tiny-v1.entry.json.write.fail.title"), (class_2561)class_2561.method_43471((String)"libjf-config-ui-tiny-v1.entry.json.write.fail.description"));
                        state.tempValue = json;
                    }
                }));
            }).method_46434(screen.field_22789 - 110, 0, info.getWidth(), 20).method_46431();
            return new WidgetFactory.Widget<Object>(state, R::nop, (class_339)button, (width, height) -> button.method_46421(width - 110));
        };
    }

    private static <T extends Number> WidgetFactory<T> slider(EntryInfo info, WidgetState state, Function<T, Double> t2d, Function<Double, T> d2t, boolean wholeNumber) {
        double min = info.getMinValue();
        double max = info.getMaxValue();
        if (!EntryInfoWidgetBuilder.isDiscrete(min)) {
            throw new IllegalArgumentException("Attempted to create slider with indiscrete minimum");
        }
        if (!EntryInfoWidgetBuilder.isDiscrete(max)) {
            throw new IllegalArgumentException("Attempted to create slider with indiscrete maximum");
        }
        return (screen, textRenderer) -> {
            CustomSlider slider = new CustomSlider(screen.field_22789 - 110, 0, info.getWidth(), 20, Double.parseDouble(state.tempValue), min, max, v -> state.updateCache(d2t.apply((Double)v)), wholeNumber);
            return new WidgetFactory.Widget<Number>(state, value -> slider.setValue((Double)t2d.apply(value)), (class_339)slider, (width, height) -> slider.method_46421(width - 110));
        };
    }

    private static boolean isDiscrete(EntryInfo<?> info) {
        return EntryInfoWidgetBuilder.isDiscrete(info.getMinValue()) && EntryInfoWidgetBuilder.isDiscrete(info.getMaxValue());
    }

    private static boolean isDiscrete(double number) {
        return !Double.isNaN(number) && Double.isFinite(number);
    }
}

