/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.config.impl.ui.tiny;

import io.gitlab.jfronny.libjf.config.api.v1.ConfigCategory;
import io.gitlab.jfronny.libjf.config.api.v1.ConfigInstance;
import io.gitlab.jfronny.libjf.config.api.v1.ui.tiny.WidgetFactory;
import io.gitlab.jfronny.libjf.config.impl.entrypoint.JfConfigSafe;
import io.gitlab.jfronny.libjf.config.impl.ui.tiny.TinyConfigScreen;
import io.gitlab.jfronny.libjf.config.impl.ui.tiny.TinyConfigTabWrapper;
import io.gitlab.jfronny.libjf.config.impl.ui.tiny.entry.EntryInfoWidgetBuilder;
import io.gitlab.jfronny.libjf.config.impl.ui.tiny.entry.EntryListWidget;
import io.gitlab.jfronny.libjf.config.impl.ui.tiny.entry.Reflowable;
import io.gitlab.jfronny.libjf.config.impl.ui.tiny.entry.WidgetState;
import io.gitlab.jfronny.libjf.config.impl.ui.tiny.presets.PresetsScreen;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_4185;
import net.minecraft.class_5250;
import net.minecraft.class_8030;
import net.minecraft.class_8087;

@Environment(value=EnvType.CLIENT)
public class TinyConfigTab
implements class_8087 {
    private final ConfigCategory config;
    private final EntryListWidget list;

    public TinyConfigTab(TinyConfigScreen screen, ConfigCategory config, class_327 textRenderer, boolean isRoot) {
        this.config = config;
        List<WidgetState<?>> widgets = EntryInfoWidgetBuilder.buildWidgets(config, screen.widgets);
        config.fix();
        for (WidgetState<?> widget : widgets) {
            widget.updateCache();
        }
        this.list = new EntryListWidget(screen.getClient(), textRenderer, screen.field_22789, screen.field_22790 - 68, 32, screen.field_22790 - 36);
        String tooltipPath = config.getTranslationPrefix() + "tooltip";
        if (JfConfigSafe.TRANSLATION_SUPPLIER.apply(tooltipPath) != null) {
            this.list.addText((class_2561)class_2561.method_43471((String)tooltipPath));
        }
        if (!isRoot && !config.getPresets().isEmpty()) {
            this.list.addReference((class_2561)class_2561.method_43471((String)"libjf-config-v1.presets"), () -> new PresetsScreen(screen, config, screen::afterSelectPreset));
        }
        for (Map.Entry entry : config.getCategories().entrySet()) {
            this.list.addReference(TinyConfigScreen.getTitle(((ConfigCategory)entry.getValue()).getTranslationPrefix()), () -> new TinyConfigScreen((ConfigCategory)entry.getValue(), screen, false));
        }
        for (WidgetState widgetState : widgets) {
            class_5250 name = class_2561.method_43471((String)(config.getTranslationPrefix() + widgetState.entry.getName()));
            WidgetFactory.Widget control = widgetState.factory == null ? null : widgetState.factory.build(screen, textRenderer);
            class_4185 resetButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"libjf-config-v1.reset"), button -> info.reset()).method_46434(screen.field_22789 - 155, 0, 40, 20).method_46431();
            BooleanSupplier resetVisible = () -> {
                boolean visible;
                resetButton.field_22763 = visible = !Objects.equals(info.entry.getDefault(), info.cachedValue);
                return visible;
            };
            Reflowable reflow = (width, height) -> {
                resetButton.method_46421(width - 155);
                if (control != null) {
                    control.reflow(width, height);
                }
            };
            if (control == null) {
                this.list.addUnknown((class_339)resetButton, resetVisible, (class_2561)name, reflow);
                continue;
            }
            this.list.addButton(control.control(), (class_339)resetButton, resetVisible, (class_2561)name, reflow);
        }
        for (ConfigInstance configInstance : config.getReferencedConfigs()) {
            if (configInstance == null) continue;
            this.list.addReference((class_2561)class_2561.method_43469((String)"libjf-config-v1.see-also", (Object[])new Object[]{TinyConfigScreen.getTitle(configInstance.getTranslationPrefix())}), () -> new TinyConfigScreen((ConfigCategory)ci, screen));
        }
    }

    public class_2561 method_48610() {
        return TinyConfigScreen.getTitle(this.config.getTranslationPrefix());
    }

    public void method_48612(Consumer<class_339> consumer) {
        consumer.accept(new TinyConfigTabWrapper(this));
    }

    public void method_48611(class_8030 tabArea) {
        this.list.refreshGrid(tabArea);
    }

    public void method_48613() {
        super.method_48613();
    }

    public EntryListWidget getList() {
        return this.list;
    }
}

