/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.config.impl.ui.tiny;

import io.gitlab.jfronny.commons.serialize.gson.api.v1.GsonHolders;
import io.gitlab.jfronny.libjf.LibJf;
import io.gitlab.jfronny.libjf.config.api.v1.ConfigCategory;
import io.gitlab.jfronny.libjf.config.api.v1.ConfigInstance;
import io.gitlab.jfronny.libjf.config.api.v1.EntryInfo;
import io.gitlab.jfronny.libjf.config.api.v1.type.Type;
import io.gitlab.jfronny.libjf.config.api.v2.ui.ConfigScreenFactory;
import io.gitlab.jfronny.libjf.config.impl.ui.tiny.EditorScreen;
import io.gitlab.jfronny.libjf.config.impl.ui.tiny.ScreenWithSaveHook;
import io.gitlab.jfronny.libjf.config.impl.ui.tiny.TinyConfigScreen;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_370;
import net.minecraft.class_374;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class TinyConfigScreenFactory
implements ConfigScreenFactory<class_437, Built> {
    public Built create(ConfigInstance config, class_437 parent) {
        EntryInfo entry;
        Type type;
        if (!(config.getEntries().size() != 1 || !config.getPresets().keySet().stream().allMatch(s -> s.equals("libjf-config-v1.default")) || !config.getReferencedConfigs().isEmpty() || !config.getCategories().isEmpty() || (type = (entry = (EntryInfo)config.getEntries().get(0)).getValueType()).isInt() || type.isLong() || type.isFloat() || type.isDouble() || type.isString() || type.isBool() || type.isEnum())) {
            String jsonified;
            try {
                jsonified = GsonHolders.CONFIG.getGson().toJson(entry.getValue());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            String key = config.getTranslationPrefix() + entry.getName();
            return new Built(new EditorScreen((class_2561)class_2561.method_43471((String)key), (class_2561)(class_1074.method_4663((String)(key + ".tooltip")) ? class_2561.method_43471((String)(key + ".tooltip")) : null), parent, jsonified, json -> {
                try {
                    entry.setValue(GsonHolders.CONFIG.getGson().fromJson(json, type.asClass()));
                    config.write();
                }
                catch (Throwable e) {
                    LibJf.LOGGER.error("Could not write element", e);
                    class_370.method_27024((class_374)class_310.method_1551().method_1566(), (class_370.class_371)class_370.class_371.field_21809, (class_2561)class_2561.method_43471((String)"libjf-config-ui-tiny-v1.entry.json.write.fail.title"), (class_2561)class_2561.method_43471((String)"libjf-config-ui-tiny-v1.entry.json.write.fail.description"));
                }
            }));
        }
        return new Built(new TinyConfigScreen((ConfigCategory)config, parent));
    }

    public int getPriority() {
        return 0;
    }

    @Environment(value=EnvType.CLIENT)
    public record Built(ScreenWithSaveHook screen) implements ConfigScreenFactory.Built<class_437>
    {
        public class_437 get() {
            return this.screen;
        }

        public void onSave(Runnable action) {
            Runnable currentHook = this.screen.saveHook;
            this.screen.saveHook = () -> {
                currentHook.run();
                action.run();
            };
        }
    }
}

