/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.config.impl.ui.tiny;

import io.gitlab.jfronny.commons.throwable.Try;
import io.gitlab.jfronny.libjf.LibJf;
import io.gitlab.jfronny.libjf.config.api.v1.ConfigCategory;
import io.gitlab.jfronny.libjf.config.impl.entrypoint.JfConfigSafe;
import io.gitlab.jfronny.libjf.config.impl.ui.tiny.Placeholder;
import io.gitlab.jfronny.libjf.config.impl.ui.tiny.ScreenWithSaveHook;
import io.gitlab.jfronny.libjf.config.impl.ui.tiny.TinyConfigTab;
import io.gitlab.jfronny.libjf.config.impl.ui.tiny.TinyConfigTabWrapper;
import io.gitlab.jfronny.libjf.config.impl.ui.tiny.entry.EntryListWidget;
import io.gitlab.jfronny.libjf.config.impl.ui.tiny.entry.WidgetState;
import io.gitlab.jfronny.libjf.config.impl.ui.tiny.presets.PresetsScreen;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_8030;
import net.minecraft.class_8087;
import net.minecraft.class_8088;
import net.minecraft.class_8089;

@Environment(value=EnvType.CLIENT)
public class TinyConfigScreen
extends ScreenWithSaveHook {
    private final class_437 parent;
    private final ConfigCategory config;
    public final List<WidgetState<?>> widgets;
    private final Placeholder<EntryListWidget> placeholder;
    private final class_8088 tabManager = new class_8088(a -> this.selectTab(((TinyConfigTabWrapper)((Object)a)).getTab()), a -> {});
    private List<TinyConfigTab> tabs;
    private final boolean considerTabs;
    public class_4185 done;
    private boolean reload = false;
    private boolean wasTabs = false;

    public static class_2561 getTitle(String categoryPath) {
        String alternatePath;
        String titlePath = categoryPath + "title";
        if (JfConfigSafe.TRANSLATION_SUPPLIER.apply(titlePath) != null) {
            return class_2561.method_43471((String)titlePath);
        }
        String string = alternatePath = categoryPath.isEmpty() ? "" : categoryPath.substring(0, categoryPath.length() - 1);
        if (JfConfigSafe.TRANSLATION_SUPPLIER.apply(alternatePath) != null) {
            return class_2561.method_43471((String)alternatePath);
        }
        return class_2561.method_43471((String)titlePath);
    }

    public TinyConfigScreen(ConfigCategory config, class_437 parent) {
        this(config, parent, TinyConfigScreen.shouldConsiderTabs(config));
    }

    public TinyConfigScreen(ConfigCategory config, class_437 parent, boolean considerTabs) {
        super(TinyConfigScreen.getTitle(config.getTranslationPrefix()));
        this.parent = parent;
        this.config = config;
        this.widgets = new LinkedList();
        this.placeholder = new Placeholder<Object>(null);
        this.considerTabs = considerTabs;
    }

    private static boolean shouldConsiderTabs(ConfigCategory config) {
        return config.getEntries().isEmpty() && config.getPresets().keySet().stream().allMatch(s -> s.equals("libjf-config-v1.default")) && config.getReferencedConfigs().isEmpty() && config.getCategories().size() > 1 && JfConfigSafe.TRANSLATION_SUPPLIER.apply(config.getTranslationPrefix() + "tooltip") == null;
    }

    public void method_25393() {
        super.method_25393();
        this.tabManager.method_48617();
    }

    protected void method_25426() {
        super.method_25426();
        if (!this.reload) {
            this.done = class_4185.method_46430((class_2561)class_5244.field_24334, button -> {
                for (WidgetState<?> state : this.widgets) {
                    Try.orElse(state::writeToEntry, e -> LibJf.LOGGER.error("Could not write config data to class", e));
                }
                this.config.getRoot().write();
                Objects.requireNonNull(this.field_22787).method_1507(this.parent);
                this.saveHook.run();
            }).method_46434(this.field_22789 / 2 + 4, this.field_22790 - 28, 150, 20).method_46431();
        } else {
            this.done.method_48229(this.field_22789 / 2 + 4, this.field_22790 - 28);
        }
        this.updateTabs();
        class_8089 tabNavigation = class_8089.method_48623((class_8088)this.tabManager, (int)this.field_22789).method_48631((class_8087[])this.tabs.toArray(TinyConfigTab[]::new)).method_48627();
        if (this.tabs.size() > 1) {
            this.method_37063((class_364)tabNavigation);
        }
        tabNavigation.method_48987(0, false);
        tabNavigation.method_49613();
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24335, button -> Objects.requireNonNull(this.field_22787).method_1507(this.parent)).method_46434(this.field_22789 / 2 - 154, this.field_22790 - 28, 150, 20).method_46431());
        this.method_37063((class_364)this.done);
        if (this.tabs.size() == 1 && !this.config.getPresets().isEmpty()) {
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"libjf-config-v1.presets"), button -> Objects.requireNonNull(this.field_22787).method_1507((class_437)new PresetsScreen(this, this.config, this::afterSelectPreset))).method_46434(4, 6, 80, 20).method_46431());
        }
        this.method_25429(this.placeholder);
        this.tabManager.method_48616(new class_8030(0, 32, this.field_22789, this.field_22790 - 68));
        this.reload = true;
    }

    private void updateTabs() {
        boolean useTabs;
        boolean bl = useTabs = this.considerTabs && !this.tabsWouldOverflow(this.config.getCategories().values());
        if (this.reload) {
            if (!this.considerTabs) {
                return;
            }
            if (this.wasTabs == useTabs) {
                return;
            }
        }
        this.wasTabs = useTabs;
        this.tabs = useTabs ? this.config.getCategories().values().stream().map(c -> new TinyConfigTab(this, (ConfigCategory)c, this.field_22793, false)).toList() : List.of(new TinyConfigTab(this, this.config, this.field_22793, true));
    }

    private boolean tabsWouldOverflow(Collection<ConfigCategory> categories) {
        int tabNavWidth = this.field_22789;
        int headerWidth = Math.min(400, tabNavWidth) - 28;
        int singleHeaderWidth = class_3532.method_28139((int)(headerWidth / categories.size()), (int)2);
        int singleTextWidth = singleHeaderWidth - 2;
        class_327 tr = class_310.method_1551().field_1772;
        for (ConfigCategory category : categories) {
            if (tr.method_27525((class_5348)TinyConfigScreen.getTitle(category.getTranslationPrefix())) <= singleTextWidth) continue;
            return true;
        }
        return false;
    }

    public void afterSelectPreset() {
        for (WidgetState<?> widget : this.widgets) {
            widget.updateCache();
        }
    }

    private void selectTab(TinyConfigTab tab) {
        this.placeholder.setChild(tab.getList());
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        Optional<class_2561> hovered;
        this.method_25420(context);
        this.placeholder.method_25394(context, mouseX, mouseY, delta);
        if (this.tabs.size() == 1) {
            int n = this.field_22789 / 2;
            Objects.requireNonNull(this.field_22793);
            context.method_27534(this.field_22793, this.field_22785, n, 16 - 9, 0xFFFFFF);
        }
        if ((hovered = this.placeholder.getChild().getHoveredEntryTitle(mouseY)).isPresent()) {
            for (WidgetState<?> info : this.widgets) {
                class_2561 text = hovered.get();
                class_5250 name = class_2561.method_43471((String)info.id);
                boolean showTooltip = text.equals(name);
                String tooltipKey = info.id + ".tooltip";
                if (showTooltip && info.error != null) {
                    showTooltip = false;
                    context.method_51438(this.field_22793, info.error, mouseX, mouseY);
                }
                if (!showTooltip || !class_1074.method_4663((String)tooltipKey)) continue;
                showTooltip = false;
                ArrayList<class_5250> tooltip = new ArrayList<class_5250>();
                for (String str : class_1074.method_4662((String)tooltipKey, (Object[])new Object[0]).split("\n")) {
                    tooltip.add(class_2561.method_43470((String)str));
                }
                context.method_51434(this.field_22793, tooltip, mouseX, mouseY);
            }
        }
        super.method_25394(context, mouseX, mouseY, delta);
    }

    public void method_25419() {
        Objects.requireNonNull(this.field_22787).method_1507(this.parent);
    }

    public class_310 getClient() {
        return Objects.requireNonNull(this.field_22787);
    }
}

