/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.config.impl.ui.tiny;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import io.gitlab.jfronny.commons.ref.R;
import io.gitlab.jfronny.libjf.config.impl.ui.tiny.ScreenWithSaveHook;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_155;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_333;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_3728;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5225;
import net.minecraft.class_5244;
import net.minecraft.class_768;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class EditorScreen
extends ScreenWithSaveHook {
    private static final int SCROLLBAR_SIZE = 7;
    private static final int HEADER_SIZE = 32;
    private static final int FOOTER_SIZE = 36;
    private static final int PADDING = 14;
    private int tickCounter;
    private final String initialText;
    private String text = "";
    private final class_3728 currentPageSelectionManager = new class_3728(this::getText, this::setText, this::getClipboard, this::setClipboard, string -> true);
    private long lastClickTime;
    private int lastClickIndex = -1;
    private double scrollAmount;
    private boolean scrolling;
    @Nullable
    private PageContent pageContent = PageContent.EMPTY;
    private final class_437 parent;
    private final Consumer<String> onSave;
    @Nullable
    private final class_2561 subtitle;

    private int getViewportHeight() {
        return this.field_22790 - 32 - 36 - 28;
    }

    private int getViewportWidth() {
        return this.field_22789 - 7 - 28;
    }

    private int getMaxScroll() {
        return Math.max(0, this.getMaxPosition() - this.getViewportHeight());
    }

    private int getMaxPosition() {
        int n = this.getPageContent().lines.length;
        Objects.requireNonNull(this.field_22793);
        return n * 9;
    }

    private int getScrollbarPositionX() {
        return this.field_22789 - 7;
    }

    private void setScrollAmount(double amount) {
        this.scrollAmount = class_3532.method_15350((double)amount, (double)0.0, (double)this.getMaxScroll());
        this.invalidatePageContent();
    }

    public EditorScreen(@Nullable class_2561 title, @Nullable class_2561 subtitle, @Nullable class_437 parent, @Nullable String text, @Nullable Consumer<String> onSave) {
        super(title == null ? class_333.field_18967 : title);
        this.parent = parent;
        this.subtitle = subtitle == null ? null : subtitle.method_27661().method_27692(class_124.field_1080);
        this.initialText = text;
        if (text != null) {
            this.text = text;
        }
        this.onSave = onSave == null ? R::nop : onSave;
    }

    public void setText(String text) {
        this.text = Objects.requireNonNull(text);
    }

    public String getText() {
        return this.text;
    }

    private void setClipboard(String clipboard) {
        if (this.field_22787 != null) {
            class_3728.method_27551((class_310)this.field_22787, (String)clipboard);
        }
    }

    private String getClipboard() {
        return this.field_22787 != null ? class_3728.method_27556((class_310)this.field_22787) : "";
    }

    public void method_25393() {
        super.method_25393();
        ++this.tickCounter;
    }

    protected void method_25426() {
        this.invalidatePageContent();
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24334, button -> this.quit(true)).method_46434(this.field_22789 / 2 + 4, this.field_22790 - 36 + 8, 150, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24335, button -> this.quit(false)).method_46434(this.field_22789 / 2 - 154, this.field_22790 - 36 + 8, 150, 20).method_46431());
    }

    private void quit(boolean save) {
        if (save && (this.initialText == null || !this.initialText.equals(this.text))) {
            this.onSave.accept(this.text);
            this.saveHook.run();
        }
        this.method_25419();
    }

    public void method_25419() {
        Objects.requireNonNull(this.field_22787).method_1507(this.parent);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (super.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        boolean bl = this.keyPressedEditMode(keyCode);
        if (bl) {
            this.invalidatePageContent();
            return true;
        }
        return false;
    }

    public boolean method_25400(char chr, int modifiers) {
        if (super.method_25400(chr, modifiers)) {
            return true;
        }
        if (class_155.method_643((char)chr)) {
            this.currentPageSelectionManager.method_16197(Character.toString(chr));
            this.invalidatePageContent();
            return true;
        }
        return false;
    }

    private boolean keyPressedEditMode(int keyCode) {
        boolean ctrl = class_437.method_25441() && !class_437.method_25442() && !class_437.method_25443();
        class_3728.class_7279 selectionType = class_437.method_25441() ? class_3728.class_7279.field_38309 : class_3728.class_7279.field_38308;
        return switch (keyCode) {
            case 65 -> {
                if (ctrl) {
                    this.currentPageSelectionManager.method_27563();
                    yield true;
                }
                yield false;
            }
            case 67 -> {
                if (ctrl) {
                    this.currentPageSelectionManager.method_27559();
                    yield true;
                }
                yield false;
            }
            case 83 -> {
                if (ctrl) {
                    this.quit(true);
                    yield true;
                }
                yield false;
            }
            case 86 -> {
                if (ctrl) {
                    this.currentPageSelectionManager.method_27554();
                    yield true;
                }
                yield false;
            }
            case 88 -> {
                if (ctrl) {
                    this.currentPageSelectionManager.method_27547();
                    yield true;
                }
                yield false;
            }
            case 259 -> {
                this.currentPageSelectionManager.method_42574(-1, selectionType);
                yield true;
            }
            case 261 -> {
                this.currentPageSelectionManager.method_42574(1, selectionType);
                yield true;
            }
            case 257, 335 -> {
                this.currentPageSelectionManager.method_16197("\n");
                yield true;
            }
            case 263 -> {
                this.currentPageSelectionManager.method_42575(-1, class_437.method_25442(), selectionType);
                yield true;
            }
            case 262 -> {
                this.currentPageSelectionManager.method_42575(1, class_437.method_25442(), selectionType);
                yield true;
            }
            case 265 -> {
                this.moveUpLine();
                yield true;
            }
            case 264 -> {
                this.moveDownLine();
                yield true;
            }
            case 268 -> {
                this.moveToLineStart();
                yield true;
            }
            case 269 -> {
                this.moveToLineEnd();
                yield true;
            }
            default -> false;
        };
    }

    private void moveUpLine() {
        this.moveVertically(-1);
    }

    private void moveDownLine() {
        this.moveVertically(1);
    }

    private void moveVertically(int lines) {
        int i = this.currentPageSelectionManager.method_16201();
        int j = this.getPageContent().getVerticalOffset(i, lines);
        this.currentPageSelectionManager.method_27560(j, class_437.method_25442());
    }

    private void moveToLineStart() {
        if (class_437.method_25441()) {
            this.currentPageSelectionManager.method_27553(class_437.method_25442());
        } else {
            int i = this.currentPageSelectionManager.method_16201();
            int j = this.getPageContent().getLineStart(i);
            this.currentPageSelectionManager.method_27560(j, class_437.method_25442());
        }
    }

    private void moveToLineEnd() {
        if (class_437.method_25441()) {
            this.currentPageSelectionManager.method_27558(class_437.method_25442());
        } else {
            int i = this.currentPageSelectionManager.method_16201();
            int j = this.getPageContent().getLineEnd(i);
            this.currentPageSelectionManager.method_27560(j, class_437.method_25442());
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context);
        if (this.subtitle == null) {
            int n = this.field_22789 / 2;
            Objects.requireNonNull(this.field_22793);
            context.method_27534(this.field_22793, this.field_22785, n, (32 - 9) / 2, 0xFFFFFF);
        } else {
            int n = this.field_22789 / 2;
            Objects.requireNonNull(this.field_22793);
            context.method_27534(this.field_22793, this.field_22785, n, 16 - 9, 0xFFFFFF);
            context.method_27534(this.field_22793, this.subtitle, this.field_22789 / 2, 16, 0xFFFFFF);
        }
        this.method_25395(null);
        if (this.field_22787.field_1687 == null) {
            RenderSystem.setShaderColor((float)0.125f, (float)0.125f, (float)0.125f, (float)1.0f);
            context.method_25290(class_437.field_44669, 0, 32, (float)(this.field_22789 - 7), (float)(this.field_22790 - 36 + (int)this.scrollAmount), this.field_22789 - 7, this.field_22790 - 32 - 36, 32, 32);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        context.method_44379(0, 32, this.field_22789 - 7, this.field_22790 - 36);
        PageContent pageContent = this.getPageContent();
        for (Line line : pageContent.lines) {
            context.method_51439(this.field_22793, line.text, line.x, line.y, -1, false);
        }
        this.drawSelection(context, pageContent.selectionRectangles);
        this.drawCursor(context, pageContent.position);
        context.method_44380();
        int i = this.getScrollbarPositionX();
        int j = i + 6;
        int m = this.getMaxScroll();
        if (m > 0) {
            int n = this.getViewportHeight() * this.getViewportHeight() / this.getMaxPosition();
            n = class_3532.method_15340((int)n, (int)32, (int)(this.getViewportHeight() - 8));
            int o = (int)this.scrollAmount * (this.getViewportHeight() - n) / m + 32;
            if (o < 32) {
                o = 32;
            }
            context.method_25294(i, 32, j, this.field_22790 - 36, -16777216);
            context.method_25294(i, o, j, o + n, -8355712);
            context.method_25294(i, o, j - 1, o + n - 1, -4144960);
        }
        super.method_25394(context, mouseX, mouseY, delta);
    }

    private void drawCursor(class_332 context, Position position) {
        if (this.tickCounter / 6 % 2 == 0) {
            position = this.absolutePositionToScreenPosition(position);
            int n = position.x;
            int n2 = position.y - 1;
            int n3 = position.x + 1;
            int n4 = position.y;
            Objects.requireNonNull(this.field_22793);
            context.method_25294(n, n2, n3, n4 + 9, -1);
        }
    }

    private void drawSelection(class_332 context, class_768[] selectionRectangles) {
        RenderSystem.enableColorLogicOp();
        RenderSystem.logicOp((GlStateManager.class_1030)GlStateManager.class_1030.field_5110);
        for (class_768 rect2i : selectionRectangles) {
            int i = rect2i.method_3321();
            int j = rect2i.method_3322();
            int k = i + rect2i.method_3319();
            int l = j + rect2i.method_3320();
            context.method_25294(i, j, k, l, -16776961);
        }
        RenderSystem.disableColorLogicOp();
    }

    private Position screenPositionToAbsolutePosition(Position position) {
        return new Position(position.x - 14, position.y - 32 - 14 + (int)this.scrollAmount);
    }

    private Position absolutePositionToScreenPosition(Position position) {
        return new Position(position.x + 14, position.y + 32 + 14 - (int)this.scrollAmount);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (super.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        boolean bl = this.scrolling = button == 0 && mouseX >= (double)this.getScrollbarPositionX();
        if (button == 0 && !this.scrolling) {
            long l = class_156.method_658();
            int i = this.getPageContent().getCursorPosition(this.field_22793, this.screenPositionToAbsolutePosition(new Position((int)mouseX, (int)mouseY)));
            if (i >= 0) {
                if (i == this.lastClickIndex && l - this.lastClickTime < 250L) {
                    if (!this.currentPageSelectionManager.method_27568()) {
                        this.selectCurrentWord(i);
                    } else {
                        this.currentPageSelectionManager.method_27563();
                    }
                } else {
                    this.currentPageSelectionManager.method_27560(i, class_437.method_25442());
                }
                this.invalidatePageContent();
            }
            this.lastClickIndex = i;
            this.lastClickTime = l;
        }
        return true;
    }

    private void selectCurrentWord(int cursor) {
        String string = this.getText();
        this.currentPageSelectionManager.method_27548(class_5225.method_27483((String)string, (int)-1, (int)cursor, (boolean)false), class_5225.method_27483((String)string, (int)1, (int)cursor, (boolean)false));
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (super.method_25403(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        if (button == 0) {
            if (this.scrolling) {
                if (mouseY < 32.0) {
                    this.setScrollAmount(0.0);
                } else if (mouseY > (double)(this.field_22790 - 36)) {
                    this.setScrollAmount(this.getMaxScroll());
                } else {
                    double d = Math.max(1, this.getMaxScroll());
                    int i = this.getViewportHeight();
                    int j = class_3532.method_15340((int)((int)((float)(i * i) / (float)this.getMaxPosition())), (int)32, (int)(i - 8));
                    double e = Math.max(1.0, d / (double)(i - j));
                    this.setScrollAmount(this.scrollAmount + deltaY * e);
                }
            } else {
                int i = this.getPageContent().getCursorPosition(this.field_22793, this.screenPositionToAbsolutePosition(new Position((int)mouseX, (int)mouseY)));
                this.currentPageSelectionManager.method_27560(i, true);
                this.invalidatePageContent();
            }
        }
        return true;
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        Objects.requireNonNull(this.field_22793);
        this.setScrollAmount(this.scrollAmount - amount * 9.0 * 2.0);
        return true;
    }

    private PageContent getPageContent() {
        if (this.pageContent == null) {
            this.pageContent = this.createPageContent();
        }
        return this.pageContent;
    }

    private void invalidatePageContent() {
        this.pageContent = null;
    }

    private PageContent createPageContent() {
        int l;
        Position position;
        boolean atEnd;
        String content = this.getText();
        if (content.isEmpty()) {
            return PageContent.EMPTY;
        }
        int i = this.currentPageSelectionManager.method_16201();
        int j = this.currentPageSelectionManager.method_16203();
        IntArrayList intList = new IntArrayList();
        ArrayList list = Lists.newArrayList();
        MutableInt lineIndexM = new MutableInt();
        MutableBoolean mutableBoolean = new MutableBoolean();
        class_5225 textHandler = this.field_22793.method_27527();
        textHandler.method_27485(content, this.getViewportWidth(), class_2583.field_24360, true, (style, start, end) -> {
            int lineIndex = lineIndexM.getAndIncrement();
            String string = content.substring(start, end);
            mutableBoolean.setValue(string.endsWith("\n"));
            String string2 = StringUtils.stripEnd((String)string, (String)" \n");
            Objects.requireNonNull(this.field_22793);
            int y = lineIndex * 9;
            Position position = this.absolutePositionToScreenPosition(new Position(0, y));
            intList.add(start);
            list.add(new Line(style, string2, position.x, position.y));
        });
        int[] is = intList.toIntArray();
        boolean bl = atEnd = i == content.length();
        if (atEnd && mutableBoolean.isTrue()) {
            int n = list.size();
            Objects.requireNonNull(this.field_22793);
            position = new Position(0, n * 9);
        } else {
            int k = EditorScreen.getLineFromOffset(is, i);
            l = this.field_22793.method_1727(content.substring(is[k], i));
            Objects.requireNonNull(this.field_22793);
            position = new Position(l, k * 9);
        }
        ArrayList list2 = Lists.newArrayList();
        if (i != j) {
            int o;
            l = Math.min(i, j);
            int m = Math.max(i, j);
            int n = EditorScreen.getLineFromOffset(is, l);
            if (n == (o = EditorScreen.getLineFromOffset(is, m))) {
                Objects.requireNonNull(this.field_22793);
                int p = n * 9;
                int q = is[n];
                list2.add(this.getLineSelectionRectangle(content, textHandler, l, m, p, q));
            } else {
                int p = n + 1 > is.length ? content.length() : is[n + 1];
                Objects.requireNonNull(this.field_22793);
                list2.add(this.getLineSelectionRectangle(content, textHandler, l, p, n * 9, is[n]));
                for (int q = n + 1; q < o; ++q) {
                    Objects.requireNonNull(this.field_22793);
                    int r = q * 9;
                    String string2 = content.substring(is[q], is[q + 1]);
                    int s = (int)textHandler.method_27482(string2);
                    Position position2 = new Position(0, r);
                    Objects.requireNonNull(this.field_22793);
                    list2.add(this.getRectFromCorners(position2, new Position(s, r + 9)));
                }
                int n2 = is[o];
                Objects.requireNonNull(this.field_22793);
                list2.add(this.getLineSelectionRectangle(content, textHandler, n2, m, o * 9, is[o]));
            }
        }
        return new PageContent(content, position, is, list.toArray(new Line[0]), list2.toArray(new class_768[0]));
    }

    static int getLineFromOffset(int[] lineStarts, int position) {
        int i = Arrays.binarySearch(lineStarts, position);
        if (i < 0) {
            return -(i + 2);
        }
        return i;
    }

    private class_768 getLineSelectionRectangle(String string, class_5225 handler, int selectionStart, int selectionEnd, int lineY, int lineStart) {
        String string2 = string.substring(lineStart, selectionStart);
        String string3 = string.substring(lineStart, selectionEnd);
        Position position = new Position((int)handler.method_27482(string2), lineY);
        int n = (int)handler.method_27482(string3);
        Objects.requireNonNull(this.field_22793);
        Position position2 = new Position(n, lineY + 9);
        return this.getRectFromCorners(position, position2);
    }

    private class_768 getRectFromCorners(Position start, Position end) {
        Position position = this.absolutePositionToScreenPosition(start);
        Position position2 = this.absolutePositionToScreenPosition(end);
        int i = Math.min(position.x, position2.x);
        int j = Math.max(position.x, position2.x);
        int k = Math.min(position.y, position2.y);
        int l = Math.max(position.y, position2.y);
        return new class_768(i, k, j - i, l - k);
    }

    @Environment(value=EnvType.CLIENT)
    static class PageContent {
        static final PageContent EMPTY = new PageContent("", new Position(0, 0), new int[]{0}, new Line[]{new Line(class_2583.field_24360, "", 0, 0)}, new class_768[0]);
        private final String pageContent;
        final Position position;
        private final int[] lineStarts;
        final Line[] lines;
        final class_768[] selectionRectangles;

        public PageContent(String pageContent, Position position, int[] lineStarts, Line[] lines, class_768[] selectionRectangles) {
            this.pageContent = pageContent;
            this.position = position;
            this.lineStarts = lineStarts;
            this.lines = lines;
            this.selectionRectangles = selectionRectangles;
        }

        public int getCursorPosition(class_327 renderer, Position position) {
            int n = position.y;
            Objects.requireNonNull(renderer);
            int i = n / 9;
            if (i < 0) {
                return 0;
            }
            if (i >= this.lines.length) {
                return this.pageContent.length();
            }
            Line line = this.lines[i];
            return this.lineStarts[i] + renderer.method_27527().method_27484(line.content, position.x, line.style);
        }

        public int getVerticalOffset(int position, int lines) {
            int m;
            int i = EditorScreen.getLineFromOffset(this.lineStarts, position);
            int j = i + lines;
            if (0 <= j && j < this.lineStarts.length) {
                int k = position - this.lineStarts[i];
                int l = this.lines[j].content.length();
                m = this.lineStarts[j] + Math.min(k, l);
            } else {
                m = position;
            }
            return m;
        }

        public int getLineStart(int position) {
            int i = EditorScreen.getLineFromOffset(this.lineStarts, position);
            return this.lineStarts[i];
        }

        public int getLineEnd(int position) {
            int i = EditorScreen.getLineFromOffset(this.lineStarts, position);
            return this.lineStarts[i] + this.lines[i].content.length();
        }
    }

    @Environment(value=EnvType.CLIENT)
    record Line(class_2583 style, String content, class_2561 text, int x, int y) {
        public Line(class_2583 style, String content, int x, int y) {
            this(style, content, (class_2561)class_2561.method_43470((String)content).method_10862(style), x, y);
        }
    }

    @Environment(value=EnvType.CLIENT)
    record Position(int x, int y) {
    }
}

