/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.spectrelib.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.illusivesoulworks.spectrelib.config.SpectreConfigSpec;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nonnull;

public class SpectreConfig {
    private final Type type;
    private final SpectreConfigSpec spec;
    private final String fileName;
    private final String modId;
    private final EnumMap<InstanceType, CommentedConfig> configData = new EnumMap(InstanceType.class);
    private final List<BiConsumer<SpectreConfig, Boolean>> loadListeners = new ArrayList<BiConsumer<SpectreConfig, Boolean>>();
    private final List<Consumer<SpectreConfig>> saveListeners = new ArrayList<Consumer<SpectreConfig>>();

    public SpectreConfig(Type type, SpectreConfigSpec spec, String modId, String fileName) {
        this.type = type;
        this.spec = spec;
        this.modId = modId;
        this.fileName = fileName;
    }

    public SpectreConfig(Type type, SpectreConfigSpec spec, String modId) {
        this(type, spec, modId, SpectreConfig.getDefaultFileName(type, modId));
    }

    private static String getDefaultFileName(Type type, String modId) {
        return String.format(Locale.ROOT, "%s-%s.toml", modId, type.suffix());
    }

    public Type getType() {
        return this.type;
    }

    public String getFileName() {
        return this.fileName;
    }

    public SpectreConfigSpec getSpec() {
        return this.spec;
    }

    public String getModId() {
        return this.modId;
    }

    public CommentedConfig getConfigData(InstanceType type) {
        return this.configData.get((Object)type);
    }

    public CommentedConfig getActiveConfigData() {
        if (this.configData.containsKey((Object)InstanceType.SERVER)) {
            return this.getConfigData(InstanceType.SERVER);
        }
        return this.getConfigData(InstanceType.GLOBAL);
    }

    public void setConfigData(InstanceType type, @Nonnull CommentedConfig configData, boolean create) {
        this.configData.put(type, configData);
        this.getSpec().setConfigData(configData, create);
    }

    public void clearServerConfigData() {
        this.configData.remove((Object)InstanceType.SERVER);
        this.getSpec().setConfigData(this.getConfigData(InstanceType.GLOBAL), false);
    }

    public void save(InstanceType type) {
        CommentedConfig config;
        if (this.configData.containsKey((Object)type) && (config = this.getConfigData(type)) instanceof CommentedFileConfig) {
            CommentedFileConfig fileConfig = (CommentedFileConfig)config;
            fileConfig.save();
        }
    }

    public Path getFullPath() {
        return ((CommentedFileConfig)this.getActiveConfigData()).getNioPath();
    }

    public void addLoadListener(BiConsumer<SpectreConfig, Boolean> listener) {
        this.loadListeners.add(listener);
    }

    public void fireLoad(boolean isReloading) {
        for (BiConsumer<SpectreConfig, Boolean> loadListener : this.loadListeners) {
            loadListener.accept(this, isReloading);
        }
    }

    public static enum InstanceType {
        GLOBAL,
        SERVER;


        public String id() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }

    public static enum Type {
        COMMON,
        CLIENT,
        SERVER;


        public String suffix() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

