/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.lavendermd.feature;

import com.mojang.logging.LogUtils;
import io.wispforest.lavendermd.Lexer;
import io.wispforest.lavendermd.MarkdownFeature;
import io.wispforest.lavendermd.Parser;
import io.wispforest.lavendermd.compiler.MarkdownCompiler;
import io.wispforest.lavendermd.compiler.OwoUICompiler;
import io.wispforest.lavendermd.util.StringNibbler;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.parsing.IncompatibleUIModelException;
import io.wispforest.owo.ui.parsing.UIModel;
import io.wispforest.owo.ui.parsing.UIModelLoader;
import io.wispforest.owo.ui.parsing.UIModelParsingException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.slf4j.Logger;

public class OwoUITemplateFeature
implements MarkdownFeature {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final TemplateProvider templateSource;

    public OwoUITemplateFeature(TemplateProvider templateProvider) {
        this.templateSource = templateProvider;
    }

    public OwoUITemplateFeature() {
        this(new TemplateProvider(){

            @Override
            public <C extends Component> C template(class_2960 model, Class<C> expectedClass, String templateName, Map<String, String> templateParams) {
                UIModel uiModel = UIModelLoader.get((class_2960)model);
                if (uiModel == null) {
                    throw new UIModelParsingException("No UI model with id '" + model + " is currently loaded");
                }
                return (C)uiModel.expandTemplate(expectedClass, templateName, templateParams);
            }
        });
    }

    public String name() {
        return "owo_ui_templates";
    }

    public boolean supportsCompiler(MarkdownCompiler<?> compiler) {
        return compiler instanceof OwoUICompiler;
    }

    public void registerTokens(MarkdownFeature.TokenRegistrar registrar) {
        registrar.registerToken((nibbler, tokens) -> {
            nibbler.skip();
            if (!nibbler.tryConsume('|')) {
                return false;
            }
            String templateLocation = nibbler.consumeUntil('|');
            if (templateLocation == null) {
                return false;
            }
            String[] splitLocation = templateLocation.split("@");
            if (splitLocation.length != 2) {
                return false;
            }
            class_2960 modelId = class_2960.method_12829((String)splitLocation[1]);
            if (modelId == null || !UIModelLoader.allLoadedModels().contains(modelId)) {
                return false;
            }
            String templateParams = "";
            if (!nibbler.tryConsume('>')) {
                templateParams = nibbler.consumeUntil('|');
                if (templateParams == null || !nibbler.tryConsume('>')) {
                    return false;
                }
            } else {
                nibbler.skip();
            }
            tokens.add(new TemplateToken(modelId, splitLocation[0], templateParams));
            return true;
        }, '<');
    }

    public void registerNodes(MarkdownFeature.NodeRegistrar registrar) {
        registrar.registerNode((parser, templateToken, tokens) -> new TemplateNode(templateToken.modelId, templateToken.templateName, templateToken.params), (token, tokens) -> {
            TemplateToken template;
            return token instanceof TemplateToken ? (template = (TemplateToken)((Object)token)) : null;
        });
    }

    @FunctionalInterface
    public static interface TemplateProvider {
        public <C extends Component> C template(class_2960 var1, Class<C> var2, String var3, Map<String, String> var4);
    }

    private static class TemplateToken
    extends Lexer.Token {
        public final class_2960 modelId;
        public final String templateName;
        public final String params;

        public TemplateToken(class_2960 modelId, String templateName, String params) {
            super("<|" + modelId + "|" + params + "|>");
            this.modelId = modelId;
            this.templateName = templateName;
            this.params = params;
        }

        public boolean isBoundary() {
            return true;
        }
    }

    private class TemplateNode
    extends Parser.Node {
        private final class_2960 modelId;
        private final String templateName;
        private final String params;

        public TemplateNode(class_2960 modelId, String templateName, String params) {
            this.modelId = modelId;
            this.templateName = templateName;
            this.params = params;
        }

        protected void visitStart(MarkdownCompiler<?> compiler) {
            try {
                StringNibbler paramReader = new StringNibbler(this.params);
                HashMap<String, String> builtParams = new HashMap<String, String>();
                while (paramReader.hasNext()) {
                    String paramName = paramReader.consumeUntil('=');
                    String paramValue = paramReader.consumeEscapedString(',', true);
                    paramReader.skip();
                    builtParams.put(paramName, paramValue);
                }
                ((OwoUICompiler)compiler).visitComponent(OwoUITemplateFeature.this.templateSource.template(this.modelId, Component.class, this.templateName, builtParams));
            }
            catch (IncompatibleUIModelException | UIModelParsingException e) {
                LOGGER.warn("Failed to build owo-ui template markdown element", e);
                ((OwoUICompiler)compiler).visitComponent((Component)Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).child(Components.label((class_2561)class_2561.method_43470((String)e.getMessage())).horizontalSizing(Sizing.fill((int)100))).padding(Insets.of((int)10)).surface(Surface.flat((int)0x77A00000).and(Surface.outline((int)0x77FF0000))));
            }
        }

        protected void visitEnd(MarkdownCompiler<?> compiler) {
        }
    }
}

