/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.common.protection.impl;

import com.mojang.authlib.GameProfile;
import eu.pb4.common.protection.api.ProtectionProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2960;

public final class ProtectionImpl {
    private static final Map<class_2960, ProtectionProvider> PROVIDERS_BY_ID = new HashMap<class_2960, ProtectionProvider>();
    private static final List<ProtectionProvider> PROVIDERS = new ArrayList<ProtectionProvider>();

    private ProtectionImpl() {
    }

    public static boolean isAreaProtected(class_1937 world, class_238 pos) {
        for (ProtectionProvider p : PROVIDERS) {
            if (!p.isAreaProtected(world, pos)) continue;
            return true;
        }
        return false;
    }

    public static boolean isProtected(class_1937 world, class_2338 pos) {
        for (ProtectionProvider p : PROVIDERS) {
            if (!p.isProtected(world, pos)) continue;
            return true;
        }
        return false;
    }

    public static boolean canBreakBlock(class_1937 world, class_2338 pos, GameProfile profile, @Nullable class_1657 player) {
        for (ProtectionProvider p : PROVIDERS) {
            if (p.canBreakBlock(world, pos, profile, player)) continue;
            return false;
        }
        return true;
    }

    public static boolean canExplodeBlock(class_1937 world, class_2338 pos, class_1927 explosion, GameProfile profile, @Nullable class_1657 player) {
        for (ProtectionProvider p : PROVIDERS) {
            if (p.canExplodeBlock(world, pos, explosion, profile, player)) continue;
            return false;
        }
        return true;
    }

    public static boolean canPlaceBlock(class_1937 world, class_2338 pos, GameProfile profile, @Nullable class_1657 player) {
        for (ProtectionProvider p : PROVIDERS) {
            if (p.canPlaceBlock(world, pos, profile, player)) continue;
            return false;
        }
        return true;
    }

    public static boolean canInteractBlock(class_1937 world, class_2338 pos, GameProfile profile, @Nullable class_1657 player) {
        for (ProtectionProvider p : PROVIDERS) {
            if (p.canInteractBlock(world, pos, profile, player)) continue;
            return false;
        }
        return true;
    }

    public static boolean canInteractEntity(class_1937 world, class_1297 entity, GameProfile profile, @Nullable class_1657 player) {
        for (ProtectionProvider p : PROVIDERS) {
            if (p.canInteractEntity(world, entity, profile, player)) continue;
            return false;
        }
        return true;
    }

    public static boolean canDamageEntity(class_1937 world, class_1297 entity, GameProfile profile, @Nullable class_1657 player) {
        for (ProtectionProvider p : PROVIDERS) {
            if (p.canDamageEntity(world, entity, profile, player)) continue;
            return false;
        }
        return true;
    }

    public static ProtectionProvider register(class_2960 identifier, ProtectionProvider provider) {
        if (PROVIDERS_BY_ID.containsKey(identifier)) {
            throw new IllegalArgumentException(identifier + " is already registered ProtectionProvider!");
        }
        PROVIDERS_BY_ID.put(identifier, provider);
        PROVIDERS.add(provider);
        return provider;
    }

    public static ProtectionProvider getProvider(class_2960 identifier) {
        return PROVIDERS_BY_ID.get(identifier);
    }

    public static Collection<class_2960> getProviderIds() {
        return PROVIDERS_BY_ID.keySet();
    }

    public static void remove(class_2960 identifier) {
        PROVIDERS.remove(PROVIDERS_BY_ID.remove(identifier));
    }
}

