/*
 * Decompiled with CFR 0.152.
 */
package me.lortseam.completeconfig.gui;

import java.lang.reflect.Type;
import java.util.function.Predicate;
import me.lortseam.completeconfig.data.Entry;
import me.lortseam.completeconfig.gui.EntryBuilder;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.apache.commons.lang3.ArrayUtils;

@Environment(value=EnvType.CLIENT)
public final class GuiProvider<T> {
    private final Predicate<Entry<?>> predicate;
    private final EntryBuilder<?, T> builder;

    public static <T, E extends Entry<?>, B extends EntryBuilder<? extends E, T>> GuiProvider<T> create(Class<E> entryType, B builder, Predicate<E> predicate, Type ... types) {
        return new GuiProvider<T>(entry -> {
            if (entry.getClass() != (entryType != null ? entryType : Entry.class)) {
                return false;
            }
            if (types.length > 0 && !ArrayUtils.contains((Object[])types, (Object)entry.getType())) {
                return false;
            }
            return predicate.test(entry);
        }, builder);
    }

    public static <T, E extends Entry<?>, B extends EntryBuilder<? extends E, T>> GuiProvider<T> create(Class<E> entryType, B builder, Type ... types) {
        return GuiProvider.create(entryType, builder, (E entry) -> true, types);
    }

    public static <T, E extends Entry<?>, B extends EntryBuilder<? extends E, T>> GuiProvider<T> create(B builder, Predicate<E> predicate, Type ... types) {
        return GuiProvider.create(null, builder, predicate, types);
    }

    public static <T, E extends Entry<?>, B extends EntryBuilder<? extends E, T>> GuiProvider<T> create(B builder, Type ... types) {
        if (types.length == 0) {
            throw new IllegalArgumentException("Types must not be empty");
        }
        return GuiProvider.create(builder, (E entry) -> true, types);
    }

    boolean test(Entry<?> entry) {
        return this.predicate.test(entry);
    }

    private GuiProvider(Predicate<Entry<?>> predicate, EntryBuilder<?, T> builder) {
        this.predicate = predicate;
        this.builder = builder;
    }

    EntryBuilder<?, T> getBuilder() {
        return this.builder;
    }
}

