/*
 * Decompiled with CFR 0.152.
 */
package me.lortseam.completeconfig.gui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.lortseam.completeconfig.data.Config;
import me.lortseam.completeconfig.data.Entry;
import me.lortseam.completeconfig.gui.GuiProvider;
import me.lortseam.completeconfig.text.TranslationKey;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public abstract class ConfigScreenBuilder<T> {
    private final List<GuiProvider<T>> providers = new ArrayList<GuiProvider<T>>();
    protected class_2960 background = class_437.field_44669;

    protected ConfigScreenBuilder(List<GuiProvider<T>> globalProviders) {
        this.providers.addAll(globalProviders);
    }

    public final ConfigScreenBuilder<T> registerProvider(GuiProvider<T> provider) {
        this.providers.add(provider);
        return this;
    }

    public final ConfigScreenBuilder<T> registerProviders(Collection<GuiProvider<T>> providers) {
        this.providers.addAll(providers);
        return this;
    }

    protected final class_2561 getTitle(Config config) {
        TranslationKey customTitle = config.getBaseTranslation().append(config.getBranch()).append("title");
        if (customTitle.exists()) {
            return customTitle.toText(new Object[0]);
        }
        return class_2561.method_43469((String)"completeconfig.gui.defaultTitle", (Object[])new Object[]{config.getMod().getName()});
    }

    public final ConfigScreenBuilder<T> setBackground(class_2960 background) {
        this.background = background;
        return this;
    }

    public abstract class_437 build(class_437 var1, Config var2);

    protected T createEntry(Entry<?> entry) {
        return this.providers.stream().filter(provider -> provider.test(entry)).findFirst().map(provider -> provider.getBuilder()).orElseThrow(() -> new UnsupportedOperationException("Could not generate GUI for entry " + entry)).build(entry);
    }
}

