/*
 * Decompiled with CFR 0.152.
 */
package me.lortseam.completeconfig.data;

import java.util.Optional;
import java.util.function.Function;
import me.lortseam.completeconfig.api.ConfigEntry;
import me.lortseam.completeconfig.data.BoundedEntry;
import me.lortseam.completeconfig.data.EntryOrigin;
import me.lortseam.completeconfig.text.TranslationKey;
import me.lortseam.completeconfig.util.NumberUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;

public class SliderEntry<T extends Number>
extends BoundedEntry<T> {
    private final T interval;
    @Environment(value=EnvType.CLIENT)
    private TranslationKey valueTranslation;

    public SliderEntry(EntryOrigin origin, T min, T max, T interval) {
        super(origin, min, max);
        this.interval = interval;
    }

    @Override
    public Optional<Function<T, class_2561>> getValueFormatter() {
        if (this.valueTranslation == null) {
            ConfigEntry.Slider slider = this.origin.getAnnotation(ConfigEntry.Slider.class);
            this.valueTranslation = !slider.valueKey().isBlank() ? this.origin.getRoot().getBaseTranslation().append(slider.valueKey()) : this.getNameTranslation().append("value");
        }
        if (this.valueTranslation.exists()) {
            return Optional.of(value -> this.valueTranslation.toText(value));
        }
        return Optional.empty();
    }

    public Optional<T> getInterval() {
        return NumberUtils.isPositive(this.interval) ? Optional.of(this.interval) : Optional.empty();
    }
}

