/*
 * Decompiled with CFR 0.152.
 */
package me.lortseam.completeconfig.data;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import me.lortseam.completeconfig.api.ConfigContainer;
import me.lortseam.completeconfig.api.ConfigGroup;
import me.lortseam.completeconfig.data.Cluster;
import me.lortseam.completeconfig.data.ClusterSet;
import me.lortseam.completeconfig.data.Config;
import me.lortseam.completeconfig.data.Entry;
import me.lortseam.completeconfig.data.EntrySet;
import me.lortseam.completeconfig.data.structure.Identifiable;
import me.lortseam.completeconfig.data.structure.StructurePart;
import me.lortseam.completeconfig.data.structure.client.Translatable;
import me.lortseam.completeconfig.text.TranslationBase;
import me.lortseam.completeconfig.text.TranslationKey;
import me.lortseam.completeconfig.util.ReflectionUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.configurate.CommentedConfigurationNode;

public abstract class Parent
implements StructurePart,
Translatable {
    private final EntrySet entries = new EntrySet(this);
    private final ClusterSet clusters = new ClusterSet(this);

    private static <C extends StructurePart & Identifiable> void propagateToChildren(Collection<C> children, CommentedConfigurationNode node, Predicate<CommentedConfigurationNode> childNodeCondition, BiConsumer<C, CommentedConfigurationNode> function) {
        for (StructurePart child : children) {
            CommentedConfigurationNode childNode = (CommentedConfigurationNode)node.node(new Object[]{((Identifiable)((Object)child)).getId()});
            if (!childNodeCondition.test(childNode)) continue;
            function.accept(child, childNode);
        }
    }

    private static <C extends StructurePart & Identifiable> void propagateToChildren(Collection<C> children, CommentedConfigurationNode node, BiConsumer<C, CommentedConfigurationNode> function) {
        Parent.propagateToChildren(children, node, childNode -> true, function);
    }

    abstract Config getRoot();

    public final Collection<Entry> getEntries() {
        return Collections.unmodifiableCollection(this.entries);
    }

    public final Collection<Cluster> getClusters() {
        return Collections.unmodifiableCollection(this.clusters);
    }

    final void resolveContainer(ConfigContainer container) {
        this.entries.resolve(container);
        for (Class<? extends ConfigContainer> clazz : container.getConfigClasses()) {
            Arrays.stream(clazz.getDeclaredFields()).filter(field -> {
                if (field.isAnnotationPresent(ConfigContainer.Transitive.class)) {
                    if (!ConfigContainer.class.isAssignableFrom(field.getType())) {
                        throw new RuntimeException("Transitive field " + field + " must implement " + ConfigContainer.class.getSimpleName());
                    }
                    return !Modifier.isStatic(field.getModifiers()) || clazz == container.getClass();
                }
                return false;
            }).map(field -> {
                if (!field.canAccess(container)) {
                    field.setAccessible(true);
                }
                try {
                    return (ConfigContainer)field.get(container);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }).forEach(xva$0 -> this.resolve((ConfigContainer)xva$0));
            Object[] nestedClasses = clazz.getDeclaredClasses();
            ArrayUtils.reverse((Object[])nestedClasses);
            Arrays.stream(nestedClasses).filter(nestedClass -> {
                if (nestedClass.isAnnotationPresent(ConfigContainer.Transitive.class)) {
                    if (!ConfigContainer.class.isAssignableFrom((Class<?>)nestedClass)) {
                        throw new RuntimeException("Transitive " + nestedClass + " must implement " + ConfigContainer.class.getSimpleName());
                    }
                    if (!Modifier.isStatic(nestedClass.getModifiers())) {
                        throw new RuntimeException("Transitive " + nestedClass + " must be static");
                    }
                    return true;
                }
                return false;
            }).map(nestedClass -> {
                try {
                    return (ConfigContainer)ReflectionUtils.instantiateClass(nestedClass);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new RuntimeException("Failed to instantiate nested " + nestedClass, e);
                }
            }).forEach(xva$0 -> this.resolve((ConfigContainer)xva$0));
        }
        Collection<ConfigContainer> transitives = container.getTransitives();
        if (transitives != null) {
            transitives.forEach(xva$0 -> this.resolve((ConfigContainer)xva$0));
        }
    }

    final void resolve(ConfigContainer ... containers) {
        for (ConfigContainer container : containers) {
            if (container instanceof ConfigGroup) {
                this.clusters.resolve((ConfigGroup)container);
                continue;
            }
            this.resolveContainer(container);
        }
    }

    @Override
    public void apply(CommentedConfigurationNode node) {
        Parent.propagateToChildren(this.entries, node, childNode -> !childNode.isNull(), StructurePart::apply);
        Parent.propagateToChildren(this.clusters, node, childNode -> !childNode.isNull(), StructurePart::apply);
    }

    @Override
    public void fetch(CommentedConfigurationNode node) {
        Parent.propagateToChildren(this.entries, node, StructurePart::fetch);
        Parent.propagateToChildren(this.clusters, node, StructurePart::fetch);
    }

    final boolean isEmpty() {
        return this.entries.isEmpty() && this.clusters.isEmpty();
    }

    @Environment(value=EnvType.CLIENT)
    public abstract TranslationKey getBaseTranslation(TranslationBase var1, @Nullable Class<? extends ConfigContainer> var2);

    @Environment(value=EnvType.CLIENT)
    public final TranslationKey getBaseTranslation() {
        return this.getBaseTranslation(TranslationBase.INSTANCE, null);
    }

    Parent() {
    }
}

