/*
 * Decompiled with CFR 0.152.
 */
package me.lortseam.completeconfig.data;

import com.google.common.base.CaseFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import me.lortseam.completeconfig.data.Entry;
import me.lortseam.completeconfig.data.EntryOrigin;
import me.lortseam.completeconfig.text.TranslationKey;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;

public class EnumEntry<T extends Enum<?>>
extends Entry<T> {
    @Environment(value=EnvType.CLIENT)
    private Map<T, TranslationKey> valueTranslations;

    public EnumEntry(EntryOrigin origin) {
        super(origin);
    }

    public final T[] getEnumConstants() {
        return (Enum[])this.getTypeClass().getEnumConstants();
    }

    @Override
    public Optional<Function<T, class_2561>> getValueFormatter() {
        if (this.valueTranslations == null) {
            this.valueTranslations = new HashMap<T, TranslationKey>();
            for (Enum value2 : this.getEnumConstants()) {
                TranslationKey translation = this.getNameTranslation().append(CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, value2.name()));
                if (!translation.exists()) continue;
                this.valueTranslations.put(value2, translation);
            }
        }
        if (this.valueTranslations.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(value -> {
            TranslationKey translation = this.valueTranslations.get(value);
            if (translation == null) {
                return class_2561.method_43470((String)value.toString());
            }
            return translation.toText(new Object[0]);
        });
    }
}

