/*
 * Decompiled with CFR 0.152.
 */
package me.lortseam.completeconfig.data;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Optional;
import me.lortseam.completeconfig.api.ConfigContainer;
import me.lortseam.completeconfig.api.ConfigEntries;
import me.lortseam.completeconfig.api.ConfigEntry;
import me.lortseam.completeconfig.data.Config;
import me.lortseam.completeconfig.data.Parent;
import me.lortseam.completeconfig.util.ReflectionUtils;

public final class EntryOrigin {
    private final Config root;
    private final Parent parent;
    private final Class<? extends ConfigContainer> declaringClass;
    private final ConfigContainer object;
    private final Field field;
    private final Type type;
    private final Type[] genericTypes;
    private final ConfigContainer container;

    EntryOrigin(Config root, Parent parent, Field field, ConfigContainer container) {
        this.root = root;
        this.parent = parent;
        this.field = field;
        this.container = container;
        this.declaringClass = field.getDeclaringClass();
        this.object = Modifier.isStatic(field.getModifiers()) ? null : container;
        this.type = ReflectionUtils.getFieldType(field);
        this.genericTypes = ReflectionUtils.getFieldGenericTypes(field);
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        A annotation = this.field.getDeclaredAnnotation(annotationType);
        if (annotation == null) {
            throw new RuntimeException("Missing required transformation annotation: " + annotationType);
        }
        return annotation;
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        return this.field.isAnnotationPresent(annotationType);
    }

    public <A extends Annotation> Optional<A> getOptionalAnnotation(Class<A> annotationType) {
        return Optional.ofNullable(this.field.getDeclaredAnnotation(annotationType));
    }

    public Optional<ConfigEntry> getMainAnnotation() {
        return this.getOptionalAnnotation(ConfigEntry.class);
    }

    public Optional<ConfigEntries> getClassAnnotation() {
        return Optional.ofNullable(this.declaringClass.getDeclaredAnnotation(ConfigEntries.class));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntryOrigin)) {
            return false;
        }
        EntryOrigin other = (EntryOrigin)o;
        ConfigContainer this$object = this.getObject();
        ConfigContainer other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        Field this$field = this.getField();
        Field other$field = other.getField();
        return !(this$field == null ? other$field != null : !((Object)this$field).equals(other$field));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ConfigContainer $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        Field $field = this.getField();
        result = result * 59 + ($field == null ? 43 : ((Object)$field).hashCode());
        return result;
    }

    Config getRoot() {
        return this.root;
    }

    Parent getParent() {
        return this.parent;
    }

    public Class<? extends ConfigContainer> getDeclaringClass() {
        return this.declaringClass;
    }

    public ConfigContainer getObject() {
        return this.object;
    }

    public Field getField() {
        return this.field;
    }

    public Type getType() {
        return this.type;
    }

    public Type[] getGenericTypes() {
        return this.genericTypes;
    }

    public ConfigContainer getContainer() {
        return this.container;
    }
}

