/*
 * Decompiled with CFR 0.152.
 */
package me.lortseam.completeconfig.data;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import lombok.NonNull;
import me.lortseam.completeconfig.api.ConfigEntries;
import me.lortseam.completeconfig.api.ConfigEntry;
import me.lortseam.completeconfig.data.ConfigRegistry;
import me.lortseam.completeconfig.data.EntryOrigin;
import me.lortseam.completeconfig.data.structure.Identifiable;
import me.lortseam.completeconfig.data.structure.StructurePart;
import me.lortseam.completeconfig.data.structure.client.DescriptionSupplier;
import me.lortseam.completeconfig.data.structure.client.Translatable;
import me.lortseam.completeconfig.data.transform.Transformation;
import me.lortseam.completeconfig.text.TranslationBase;
import me.lortseam.completeconfig.text.TranslationKey;
import me.lortseam.completeconfig.util.ReflectionUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;

public class Entry<T>
implements StructurePart,
Identifiable,
Translatable,
DescriptionSupplier {
    private static final Logger logger = LoggerFactory.getLogger((String)"CompleteConfig");
    private static final Transformation DEFAULT_TRANSFORMATION = new Transformation(Transformation.filter(), Entry::new);
    protected final EntryOrigin origin;
    private final Class<T> typeClass;
    private final String id;
    private final T defaultValue;
    @Environment(value=EnvType.CLIENT)
    private TranslationKey translation;
    @Environment(value=EnvType.CLIENT)
    private TranslationKey descriptionTranslation;
    private final boolean requiresRestart;
    private final String comment;
    private final Setter<T> setter;
    private final UnaryOperator<T> revisor;

    static Entry<?> create(EntryOrigin origin) {
        return Stream.concat(origin.getRoot().getRegistry().getTransformations().stream(), Stream.of(DEFAULT_TRANSFORMATION)).filter(transformation -> transformation.test(origin)).findFirst().orElseThrow(() -> new UnsupportedOperationException("No suitable transformation found for field " + origin.getField())).getTransformer().transform(origin);
    }

    protected Entry(EntryOrigin origin, UnaryOperator<T> revisor) {
        ConfigRegistry.registerEntryOrigin(origin);
        this.origin = origin;
        this.revisor = revisor;
        if (!this.getField().canAccess(origin.getObject())) {
            this.getField().setAccessible(true);
        }
        this.typeClass = ReflectionUtils.getTypeClass(origin.getType());
        Optional<ConfigEntry> annotation = origin.getMainAnnotation();
        this.id = annotation.isPresent() && !annotation.get().value().isBlank() ? annotation.get().value() : this.getField().getName();
        this.requiresRestart = annotation.isPresent() && annotation.get().requiresRestart();
        this.comment = annotation.isPresent() && !annotation.get().comment().isBlank() ? annotation.get().comment() : null;
        this.setter = ReflectionUtils.getSetterMethod(this.getField(), origin.getObject()).map(method -> (x$0, xva$1) -> method.invoke(x$0, xva$1)).orElse((object, value) -> this.getField().set(object, value));
        this.defaultValue = this.getValue();
    }

    protected Entry(EntryOrigin origin) {
        this(origin, null);
    }

    private Field getField() {
        return this.origin.getField();
    }

    public final Type getType() {
        return this.origin.getType();
    }

    public final Type[] getGenericTypes() {
        return this.origin.getGenericTypes();
    }

    public final T getValue() {
        if (this.update()) {
            return this.getValue();
        }
        return this.getFieldValue();
    }

    private T getFieldValue() {
        try {
            return (T)Objects.requireNonNull(this.getField().get(this.origin.getObject()), this.getField().toString());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to get entry value", e);
        }
    }

    public final void setValue(@NonNull T value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.update(value);
    }

    private boolean update() {
        return this.update(this.getFieldValue());
    }

    private boolean update(T value) {
        if (this.revisor != null) {
            value = this.revisor.apply(value);
        }
        if (value.equals(this.getFieldValue())) {
            return false;
        }
        this.set(value);
        this.origin.getContainer().onContainerEntryUpdate();
        this.origin.getRoot().onConfigEntryUpdate();
        return true;
    }

    private void set(T value) {
        try {
            this.setter.set(this.origin.getObject(), value);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("Failed to set entry value", e);
        }
    }

    @Override
    public final TranslationKey getNameTranslation() {
        if (this.translation == null) {
            Optional<ConfigEntry> annotation = this.origin.getMainAnnotation();
            if (annotation.isPresent() && !annotation.get().nameKey().isBlank()) {
                this.translation = this.origin.getRoot().getBaseTranslation().append(annotation.get().nameKey());
            } else {
                TranslationBase translationBase = this.origin.getClassAnnotation().map(ConfigEntries::translationBase).orElse(TranslationBase.INSTANCE);
                this.translation = this.origin.getParent().getBaseTranslation(translationBase, this.origin.getDeclaringClass()).append(this.id);
            }
        }
        return this.translation;
    }

    @Override
    public final Optional<TranslationKey> getDescriptionTranslation() {
        if (this.descriptionTranslation == null) {
            Optional<ConfigEntry> annotation = this.origin.getMainAnnotation();
            this.descriptionTranslation = annotation.isPresent() && !annotation.get().descriptionKey().isBlank() ? this.origin.getRoot().getBaseTranslation().append(annotation.get().descriptionKey()) : this.getNameTranslation().append("description");
        }
        return this.descriptionTranslation.exists() ? Optional.of(this.descriptionTranslation) : Optional.empty();
    }

    @Environment(value=EnvType.CLIENT)
    public Optional<Function<T, class_2561>> getValueFormatter() {
        return Optional.empty();
    }

    @Override
    public final void apply(CommentedConfigurationNode node) {
        try {
            Object value = node.get(this.getType());
            if (value == null) {
                throw new SerializationException((ConfigurationNode)node, this.getType(), "Unable to deserialize value of this type");
            }
            this.setValue(value);
        }
        catch (SerializationException e) {
            logger.error("Failed to apply value to entry", (Throwable)e);
        }
    }

    @Override
    public final void fetch(CommentedConfigurationNode node) {
        try {
            node.set(ReflectionUtils.boxType(this.getType()), this.getValue());
            if (this.comment != null) {
                node.comment(this.comment);
            }
        }
        catch (SerializationException e) {
            logger.error("Failed to fetch value from entry", (Throwable)e);
        }
    }

    public final String toString() {
        return this.getField().toString();
    }

    public Class<T> getTypeClass() {
        return this.typeClass;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public boolean requiresRestart() {
        return this.requiresRestart;
    }

    @FunctionalInterface
    private static interface Setter<T> {
        public void set(Object var1, T var2) throws IllegalAccessException, InvocationTargetException;
    }
}

