/*
 * Decompiled with CFR 0.152.
 */
package me.lortseam.completeconfig.data;

import java.awt.Color;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import lombok.NonNull;
import me.lortseam.completeconfig.CompleteConfig;
import me.lortseam.completeconfig.data.ConfigRegistry;
import me.lortseam.completeconfig.data.extension.DataExtension;
import me.lortseam.completeconfig.data.transform.Transformation;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.configurate.hocon.HoconConfigurationLoader;
import org.spongepowered.configurate.objectmapping.ObjectMapper;
import org.spongepowered.configurate.serialize.CoercionFailedException;
import org.spongepowered.configurate.serialize.TypeSerializer;
import org.spongepowered.configurate.serialize.TypeSerializerCollection;

public final class ConfigOptions {
    private static final TypeSerializerCollection COMMON_TYPE_SERIALIZERS = TypeSerializerCollection.builder().registerExact(TypeSerializer.of(Color.class, (v, pass) -> v.getRGB(), v -> {
        if (v instanceof Integer) {
            return new Color((Integer)v, true);
        }
        throw new CoercionFailedException(v, Color.class.getSimpleName());
    })).build();
    private final String modId;
    private final String[] branch;
    private final TypeSerializerCollection typeSerializers;
    private final String fileHeader;
    private final ConfigRegistry registry = new ConfigRegistry();

    public static Builder mod(@NonNull String modId) {
        if (modId == null) {
            throw new NullPointerException("modId is marked non-null but is null");
        }
        if (!FabricLoader.getInstance().isModLoaded(modId)) {
            throw new IllegalArgumentException("Mod " + modId + " is not loaded");
        }
        return new Builder(modId);
    }

    private ConfigOptions(String modId, String[] branch, TypeSerializerCollection typeSerializers, List<Transformation> transformations, String fileHeader) {
        this.modId = modId;
        this.branch = branch;
        this.typeSerializers = typeSerializers;
        this.registry.registerTransformations(transformations);
        this.fileHeader = fileHeader;
    }

    HoconConfigurationLoader createDefaultLoader() {
        return this.createLoader(builder -> {
            Path path = FabricLoader.getInstance().getConfigDir();
            String[] subPath = (String[])ArrayUtils.addFirst((Object[])this.branch, (Object)this.modId);
            subPath[subPath.length - 1] = subPath[subPath.length - 1] + ".conf";
            for (String child : subPath) {
                path = path.resolve(child);
            }
            builder.path(path);
        });
    }

    HoconConfigurationLoader createLoader(Consumer<HoconConfigurationLoader.Builder> builderConsumer) {
        HoconConfigurationLoader.Builder builder = (HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().defaultOptions(options -> options.serializers(typeSerializersBuilder -> {
            typeSerializersBuilder.registerAll(this.typeSerializers);
            typeSerializersBuilder.registerAll(COMMON_TYPE_SERIALIZERS);
            for (TypeSerializerCollection typeSerializers : CompleteConfig.collectExtensions(DataExtension.class, DataExtension::getTypeSerializers)) {
                typeSerializersBuilder.registerAll(typeSerializers);
            }
        }).header(this.fileHeader));
        builderConsumer.accept(builder);
        return builder.build();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConfigOptions)) {
            return false;
        }
        ConfigOptions other = (ConfigOptions)o;
        String this$modId = this.getModId();
        String other$modId = other.getModId();
        if (this$modId == null ? other$modId != null : !this$modId.equals(other$modId)) {
            return false;
        }
        return Arrays.deepEquals(this.getBranch(), other.getBranch());
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $modId = this.getModId();
        result = result * 59 + ($modId == null ? 43 : $modId.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getBranch());
        return result;
    }

    public String toString() {
        return "ConfigOptions(modId=" + this.getModId() + ", branch=" + Arrays.deepToString(this.getBranch()) + ")";
    }

    String getModId() {
        return this.modId;
    }

    String[] getBranch() {
        return this.branch;
    }

    ConfigRegistry getRegistry() {
        return this.registry;
    }

    public static final class Builder {
        private final String modId;
        private String[] branch = new String[0];
        private String fileHeader;
        private final TypeSerializerCollection.Builder typeSerializerCollectionBuilder = TypeSerializerCollection.builder();
        private final List<Transformation> transformations = new ArrayList<Transformation>();

        private Builder(String modId) {
            this.modId = modId;
        }

        public Builder branch(@NonNull String[] branch) {
            if (branch == null) {
                throw new NullPointerException("branch is marked non-null but is null");
            }
            Arrays.stream(branch).forEach(Objects::requireNonNull);
            this.branch = branch;
            return this;
        }

        public Builder typeSerializers(@NonNull TypeSerializerCollection typeSerializers) {
            if (typeSerializers == null) {
                throw new NullPointerException("typeSerializers is marked non-null but is null");
            }
            this.typeSerializerCollectionBuilder.registerAll(typeSerializers);
            return this;
        }

        public Builder objectMapperFactory(@NonNull ObjectMapper.Factory objectMapperFactory) {
            if (objectMapperFactory == null) {
                throw new NullPointerException("objectMapperFactory is marked non-null but is null");
            }
            this.typeSerializerCollectionBuilder.registerAnnotatedObjects(objectMapperFactory);
            return this;
        }

        public Builder transformation(@NonNull Transformation transformation) {
            if (transformation == null) {
                throw new NullPointerException("transformation is marked non-null but is null");
            }
            this.transformations.add(transformation);
            return this;
        }

        public Builder transformations(@NotNull List<Transformation> transformations) {
            this.transformations.addAll(transformations);
            return this;
        }

        public Builder fileHeader(@NonNull String fileHeader) {
            if (fileHeader == null) {
                throw new NullPointerException("fileHeader is marked non-null but is null");
            }
            this.fileHeader = fileHeader;
            return this;
        }

        ConfigOptions build() {
            return new ConfigOptions(this.modId, (String[])this.branch.clone(), this.typeSerializerCollectionBuilder.build(), this.transformations, this.fileHeader);
        }
    }
}

