/*
 * Decompiled with CFR 0.152.
 */
package me.lortseam.completeconfig.data;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.Callable;
import lombok.NonNull;
import me.lortseam.completeconfig.api.ConfigContainer;
import me.lortseam.completeconfig.data.ConfigOptions;
import me.lortseam.completeconfig.data.ConfigRegistry;
import me.lortseam.completeconfig.data.Parent;
import me.lortseam.completeconfig.text.TranslationBase;
import me.lortseam.completeconfig.text.TranslationKey;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.ConfigurateException;
import org.spongepowered.configurate.hocon.HoconConfigurationLoader;

public class Config
extends Parent
implements ConfigContainer {
    private static final Logger logger = LoggerFactory.getLogger((String)"CompleteConfig");
    private final ConfigOptions options;
    private final HoconConfigurationLoader loader;
    private Runnable resolver;
    @Environment(value=EnvType.CLIENT)
    private TranslationKey translation;

    public Config(@NonNull ConfigOptions.Builder optionsBuilder, ConfigContainer ... containers) {
        if (optionsBuilder == null) {
            throw new NullPointerException("optionsBuilder is marked non-null but is null");
        }
        if (containers == null) {
            throw new NullPointerException("containers is marked non-null but is null");
        }
        Arrays.stream(containers).forEach(Objects::requireNonNull);
        this.options = optionsBuilder.build();
        this.loader = this.options.createDefaultLoader();
        this.resolver = () -> {
            this.resolve(this);
            this.resolve(containers);
            if (this.isEmpty()) {
                logger.warn(this + " is empty");
            }
        };
        ConfigRegistry.registerConfig(this);
    }

    public Config(String modId, String[] branch, ConfigContainer ... containers) {
        this(ConfigOptions.mod(modId).branch(branch), containers);
    }

    public Config(String modId, ConfigContainer ... containers) {
        this(ConfigOptions.mod(modId), containers);
    }

    public final ModMetadata getMod() {
        return ((ModContainer)FabricLoader.getInstance().getModContainer(this.options.getModId()).get()).getMetadata();
    }

    public final String[] getBranch() {
        return this.options.getBranch();
    }

    private void deserialize(HoconConfigurationLoader loader) {
        if (this.resolver != null) {
            this.resolver.run();
            this.resolver = null;
        }
        if (this.isEmpty()) {
            return;
        }
        try {
            CommentedConfigurationNode root = (CommentedConfigurationNode)loader.load();
            if (!root.isNull()) {
                this.apply(root);
            }
        }
        catch (ConfigurateException e) {
            logger.error("Failed to load config", (Throwable)e);
        }
    }

    public final void deserialize(Callable<BufferedReader> source) {
        this.deserialize(this.options.createLoader(builder -> builder.source(source)));
    }

    public final void load() {
        this.deserialize(this.loader);
        this.save();
    }

    private void serialize(HoconConfigurationLoader loader) {
        if (this.resolver != null) {
            throw new IllegalStateException("Cannot serialize config before it was loaded");
        }
        if (this.isEmpty()) {
            return;
        }
        CommentedConfigurationNode root = (CommentedConfigurationNode)loader.createNode();
        this.fetch(root);
        try {
            loader.save(root);
        }
        catch (ConfigurateException e) {
            logger.error("Failed to serialize config", (Throwable)e);
        }
    }

    public final void serialize(Callable<BufferedWriter> sink) {
        this.serialize(this.options.createLoader(builder -> builder.sink(sink)));
    }

    public final void save() {
        this.serialize(this.loader);
    }

    protected void onConfigEntryUpdate() {
    }

    @Override
    Config getRoot() {
        return this;
    }

    ConfigRegistry getRegistry() {
        return this.options.getRegistry();
    }

    @Override
    public TranslationKey getBaseTranslation(TranslationBase translationBase, @Nullable Class<? extends ConfigContainer> clazz) {
        return new TranslationKey(this);
    }

    @Override
    public TranslationKey getNameTranslation() {
        if (this.translation == null) {
            this.translation = this.getBaseTranslation();
        }
        return this.translation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Config)) {
            return false;
        }
        Config other = (Config)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ConfigOptions this$options = this.options;
        ConfigOptions other$options = other.options;
        return !(this$options == null ? other$options != null : !((Object)this$options).equals(other$options));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Config;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ConfigOptions $options = this.options;
        result = result * 59 + ($options == null ? 43 : ((Object)$options).hashCode());
        return result;
    }

    public String toString() {
        return "Config(options=" + this.options + ")";
    }
}

