/*
 * Decompiled with CFR 0.152.
 */
package me.lortseam.completeconfig.data;

import com.google.common.base.CaseFormat;
import java.util.Optional;
import me.lortseam.completeconfig.api.ConfigContainer;
import me.lortseam.completeconfig.api.ConfigGroup;
import me.lortseam.completeconfig.data.Config;
import me.lortseam.completeconfig.data.Parent;
import me.lortseam.completeconfig.data.structure.Identifiable;
import me.lortseam.completeconfig.data.structure.client.DescriptionSupplier;
import me.lortseam.completeconfig.text.TranslationBase;
import me.lortseam.completeconfig.text.TranslationKey;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.configurate.CommentedConfigurationNode;

public final class Cluster
extends Parent
implements Identifiable,
DescriptionSupplier {
    private final Parent parent;
    private final ConfigGroup group;
    private final String comment;
    @Environment(value=EnvType.CLIENT)
    private TranslationKey translation;
    @Environment(value=EnvType.CLIENT)
    private TranslationKey descriptionTranslation;
    @Environment(value=EnvType.CLIENT)
    private class_2960 background;

    Cluster(Parent parent, ConfigGroup group) {
        this.parent = parent;
        this.group = group;
        this.comment = group.getComment();
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            this.background = group.getBackground();
        }
    }

    @Override
    Config getRoot() {
        return this.parent.getRoot();
    }

    @Override
    public TranslationKey getNameTranslation() {
        if (this.translation == null) {
            String customKey = this.group.getNameKey();
            this.translation = customKey != null && !customKey.isBlank() ? this.getRoot().getBaseTranslation().append(customKey) : this.getBaseTranslation();
        }
        return this.translation;
    }

    @Override
    public Optional<TranslationKey> getDescriptionTranslation() {
        if (this.descriptionTranslation == null) {
            String customKey = this.group.getDescriptionKey();
            this.descriptionTranslation = customKey != null && !customKey.isBlank() ? this.getRoot().getBaseTranslation().append(customKey) : this.getNameTranslation().append("description");
        }
        return this.descriptionTranslation.exists() ? Optional.of(this.descriptionTranslation) : Optional.empty();
    }

    @Environment(value=EnvType.CLIENT)
    public Optional<class_2960> getBackground() {
        return Optional.ofNullable(this.background);
    }

    @Override
    public void fetch(CommentedConfigurationNode node) {
        if (this.comment != null) {
            node.comment(this.comment);
        }
        super.fetch(node);
    }

    @Override
    public String getId() {
        return this.group.getId();
    }

    @Override
    public TranslationKey getBaseTranslation(TranslationBase translationBase, @Nullable Class<? extends ConfigContainer> clazz) {
        return switch (translationBase) {
            default -> throw new IncompatibleClassChangeError();
            case TranslationBase.INSTANCE -> this.parent.getBaseTranslation().append(this.group.getId());
            case TranslationBase.CLASS -> {
                if (clazz == null || !clazz.isInstance(this.group)) {
                    clazz = this.group.getClass();
                }
                yield this.parent.getBaseTranslation(translationBase, null).append(CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, clazz.getSimpleName()));
            }
        };
    }
}

