/*
 * Decompiled with CFR 0.152.
 */
package me.lortseam.completeconfig.data;

import me.lortseam.completeconfig.data.Entry;
import me.lortseam.completeconfig.data.EntryOrigin;
import me.lortseam.completeconfig.util.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoundedEntry<T extends Number>
extends Entry<T> {
    private static final Logger logger = LoggerFactory.getLogger((String)"CompleteConfig");
    private final T min;
    private final T max;

    public BoundedEntry(EntryOrigin origin, T min, T max) {
        super(origin, value -> {
            if (NumberUtils.compare(value, min) < 0) {
                logger.warn("Tried to set value of field " + origin.getField() + " to a value less than lower bound, setting to minimum now");
                return min;
            }
            if (NumberUtils.compare(value, max) > 0) {
                logger.warn("Tried to set value of field " + origin.getField() + " to a value greater than upper bound, setting to maximum now");
                return max;
            }
            return value;
        });
        this.min = min;
        this.max = max;
    }

    public T getMin() {
        return this.min;
    }

    public T getMax() {
        return this.max;
    }
}

