/*
 * Decompiled with CFR 0.152.
 */
package me.lortseam.completeconfig.data;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import me.lortseam.completeconfig.api.ConfigEntry;
import me.lortseam.completeconfig.data.Entry;
import me.lortseam.completeconfig.data.EntryOrigin;
import me.lortseam.completeconfig.text.TranslationKey;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;

public class BooleanEntry
extends Entry<Boolean> {
    @Environment(value=EnvType.CLIENT)
    private Map<Boolean, TranslationKey> valueTranslations;
    @Environment(value=EnvType.CLIENT)
    private final boolean checkbox;

    public BooleanEntry(EntryOrigin origin) {
        super(origin);
        this.checkbox = origin.isAnnotationPresent(ConfigEntry.Checkbox.class);
    }

    @Environment(value=EnvType.CLIENT)
    private Map<Boolean, TranslationKey> getValueTranslations() {
        if (this.valueTranslations == null) {
            TranslationKey defaultFalseTranslation;
            TranslationKey defaultTrueTranslation;
            this.valueTranslations = new HashMap<Boolean, TranslationKey>();
            Optional<ConfigEntry.Boolean> annotation = this.origin.getOptionalAnnotation(ConfigEntry.Boolean.class);
            if (annotation.isPresent()) {
                if (!annotation.get().trueKey().isBlank()) {
                    this.valueTranslations.put(true, this.origin.getRoot().getBaseTranslation().append(annotation.get().trueKey()));
                }
                if (!annotation.get().falseKey().isBlank()) {
                    this.valueTranslations.put(false, this.origin.getRoot().getBaseTranslation().append(annotation.get().falseKey()));
                }
            }
            if ((defaultTrueTranslation = this.getNameTranslation().append("true")).exists()) {
                this.valueTranslations.putIfAbsent(true, defaultTrueTranslation);
            }
            if ((defaultFalseTranslation = this.getNameTranslation().append("false")).exists()) {
                this.valueTranslations.putIfAbsent(false, defaultFalseTranslation);
            }
        }
        return this.valueTranslations;
    }

    @Override
    public Optional<Function<Boolean, class_2561>> getValueFormatter() {
        if (this.getValueTranslations().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(value -> this.getValueTranslations().get(value).toText(new Object[0]));
    }

    public boolean isCheckbox() {
        return this.checkbox;
    }
}

