/*
 * Decompiled with CFR 0.152.
 */
package me.lortseam.completeconfig;

import com.google.common.collect.Sets;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.NonNull;
import me.lortseam.completeconfig.CompleteConfigExtender;
import me.lortseam.completeconfig.CompleteConfigInitializer;
import me.lortseam.completeconfig.Extension;
import me.lortseam.completeconfig.data.extension.ClientDataExtension;
import me.lortseam.completeconfig.data.extension.DataExtension;
import me.lortseam.completeconfig.data.extension.ServerDataExtension;
import me.lortseam.completeconfig.extensions.clothbasicmath.ClothBasicMathExtension;
import me.lortseam.completeconfig.extensions.clothconfig.ClothConfigClientDataExtension;
import me.lortseam.completeconfig.extensions.minecraft.MinecraftClientDataExtension;
import me.lortseam.completeconfig.util.ReflectionUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.entrypoint.EntrypointContainer;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CompleteConfig {
    private static final Logger logger = LoggerFactory.getLogger((String)"CompleteConfig");
    private static final Set<Class<? extends Extension>> validExtensionTypes = Sets.newHashSet((Object[])new Class[]{DataExtension.class});
    private static final Set<Extension> extensions = new HashSet<Extension>();

    public static void registerExtensionType(@NonNull Class<? extends Extension> extensionType, EnvType environment, String ... mods) {
        if (extensionType == null) {
            throw new NullPointerException("extensionType is marked non-null but is null");
        }
        if (validExtensionTypes.contains(extensionType)) {
            return;
        }
        if (environment != null && FabricLoader.getInstance().getEnvironmentType() != environment || Arrays.stream(mods).anyMatch(modId -> !FabricLoader.getInstance().isModLoaded(Objects.requireNonNull(modId)))) {
            return;
        }
        validExtensionTypes.add(extensionType);
    }

    public static void registerExtensionType(@NonNull Class<? extends Extension> extensionType, String ... mods) {
        if (extensionType == null) {
            throw new NullPointerException("extensionType is marked non-null but is null");
        }
        CompleteConfig.registerExtensionType(extensionType, null, mods);
    }

    private static void registerExtensions(@Nullable Collection<Class<? extends Extension>> extensions) {
        if (extensions == null) {
            return;
        }
        for (Class<? extends Extension> extension : extensions) {
            CompleteConfig.registerExtension(extension);
        }
    }

    private static void registerExtension(Extension extension) {
        extensions.add(extension);
        CompleteConfig.registerExtensions(extension.children());
    }

    private static void registerExtension(Class<? extends Extension> extension) {
        if (!validExtensionTypes.containsAll(Arrays.asList(extension.getInterfaces()))) {
            return;
        }
        try {
            CompleteConfig.registerExtension(ReflectionUtils.instantiateClass(extension));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            logger.error("Failed to instantiate extension " + extension, (Throwable)e);
        }
    }

    private static void registerExtension(@NonNull String modId, @NonNull Class<? extends Extension> extension) {
        if (modId == null) {
            throw new NullPointerException("modId is marked non-null but is null");
        }
        if (extension == null) {
            throw new NullPointerException("extension is marked non-null but is null");
        }
        if (!FabricLoader.getInstance().isModLoaded(modId)) {
            return;
        }
        CompleteConfig.registerExtension(extension);
    }

    public static <E extends Extension, T> Collection<T> collectExtensions(Class<E> extensionType, Function<E, T> function) {
        return extensions.stream().filter(extensionType::isInstance).map(extension -> function.apply(extension)).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private CompleteConfig() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        CompleteConfig.registerExtensionType(ClientDataExtension.class, EnvType.CLIENT, new String[0]);
        CompleteConfig.registerExtensionType(ServerDataExtension.class, EnvType.SERVER, new String[0]);
        for (EntrypointContainer entrypoint : FabricLoader.getInstance().getEntrypointContainers("completeconfig", CompleteConfigInitializer.class)) {
            ((CompleteConfigInitializer)entrypoint.getEntrypoint()).onInitializeCompleteConfig();
        }
        CompleteConfig.registerExtension(MinecraftClientDataExtension.class);
        CompleteConfig.registerExtension("cloth-basic-math", ClothBasicMathExtension.class);
        CompleteConfig.registerExtension("cloth-config", ClothConfigClientDataExtension.class);
        for (EntrypointContainer entrypoint : FabricLoader.getInstance().getEntrypointContainers("completeconfig-extender", CompleteConfigExtender.class)) {
            CompleteConfigExtender extender = (CompleteConfigExtender)entrypoint.getEntrypoint();
            CompleteConfig.registerExtensions(extender.getExtensions());
            Map<String, Class<? extends Extension>> providedExtensions = extender.getProvidedExtensions();
            if (providedExtensions == null) continue;
            providedExtensions.forEach(CompleteConfig::registerExtension);
        }
    }
}

