/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.config.impl.reflect.entrypoint;

import io.gitlab.jfronny.libjf.LibJf;
import io.gitlab.jfronny.libjf.config.api.v1.ConfigHolder;
import io.gitlab.jfronny.libjf.config.api.v1.JfConfig;
import io.gitlab.jfronny.libjf.config.api.v1.JfCustomConfig;
import io.gitlab.jfronny.libjf.config.api.v1.dsl.ConfigBuilder;
import io.gitlab.jfronny.libjf.config.api.v1.dsl.DSL;
import io.gitlab.jfronny.libjf.config.api.v1.reflect.ReflectiveConfigBuilder;
import io.gitlab.jfronny.libjf.config.impl.entrypoint.JfConfigSafe;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.entrypoint.EntrypointContainer;
import net.fabricmc.loader.api.entrypoint.PreLaunchEntrypoint;

public class JfConfigReflectSafe
implements PreLaunchEntrypoint {
    public void onPreLaunch() {
        LibJf.setup();
        for (EntrypointContainer config : FabricLoader.getInstance().getEntrypointContainers("libjf:config", Object.class)) {
            JfConfigReflectSafe.registerIfMissing(config.getProvider().getMetadata().getId(), config.getEntrypoint());
        }
    }

    public static void registerIfMissing(String modId, Object config) {
        if (JfConfigSafe.REGISTERED_MODS.add(modId)) {
            ConfigHolder.getInstance().migrateFiles(modId);
            if (config instanceof JfCustomConfig) {
                JfCustomConfig cfg = (JfCustomConfig)config;
                cfg.register(DSL.create((String)modId));
            } else {
                Class<?> klazz = config.getClass();
                if (klazz.isAnnotationPresent(JfConfig.class)) {
                    DSL.create((String)modId).register((ConfigBuilder.ConfigBuilderFunction)ReflectiveConfigBuilder.of(modId, klazz));
                } else {
                    LibJf.LOGGER.error("Attempted to register improper config for mod " + modId + " (missing @JfConfig annotation or JfCustomConfig interface)");
                }
            }
        }
    }
}

