/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.config.impl.reflect;

import io.gitlab.jfronny.commons.reflect.Reflect;
import io.gitlab.jfronny.commons.throwable.ThrowingConsumer;
import io.gitlab.jfronny.libjf.LibJf;
import io.gitlab.jfronny.libjf.config.api.v1.Category;
import io.gitlab.jfronny.libjf.config.api.v1.Entry;
import io.gitlab.jfronny.libjf.config.api.v1.EntryInfo;
import io.gitlab.jfronny.libjf.config.api.v1.JfConfig;
import io.gitlab.jfronny.libjf.config.api.v1.Preset;
import io.gitlab.jfronny.libjf.config.api.v1.Verifier;
import io.gitlab.jfronny.libjf.config.api.v1.dsl.CategoryBuilder;
import io.gitlab.jfronny.libjf.config.api.v1.dsl.ConfigBuilder;
import io.gitlab.jfronny.libjf.config.api.v1.reflect.ReflectiveConfigBuilder;
import io.gitlab.jfronny.libjf.config.impl.AuxiliaryMetadata;
import io.gitlab.jfronny.libjf.config.impl.dsl.DslEntryInfo;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.function.Function;

public class ReflectiveConfigBuilderImpl
implements ReflectiveConfigBuilder {
    private final AuxiliaryMetadata rootMeta;
    private final Class<?> rootClass;
    private final Class<?> rootTweaker;
    private final String id;

    public ReflectiveConfigBuilderImpl(String id, Class<?> klazz) {
        this.id = id;
        this.rootClass = Objects.requireNonNull(klazz);
        JfConfig annotation = klazz.getAnnotation(JfConfig.class);
        this.rootTweaker = annotation.tweaker();
        this.rootMeta = AuxiliaryMetadata.of((JfConfig)annotation).merge(AuxiliaryMetadata.forMod((String)id));
    }

    public ConfigBuilder<?> apply(ConfigBuilder<?> builder) {
        return this.applyCategory(builder, this.rootClass, this.findTweaker(this.rootTweaker, ConfigBuilder.class), this.rootMeta);
    }

    private <T extends CategoryBuilder<?>> T applyCategory(T builder, Class<?> configClass, Function<T, T> tweaker, AuxiliaryMetadata meta) {
        meta.applyTo(builder);
        for (Field field : configClass.getFields()) {
            if (!field.isAnnotationPresent(Entry.class)) continue;
            builder.value((EntryInfo)DslEntryInfo.ofField((Field)field));
        }
        for (AccessibleObject accessibleObject : configClass.getMethods()) {
            try {
                if (accessibleObject.isAnnotationPresent(Preset.class)) {
                    builder.addPreset(builder.getTranslationPrefix() + ((Method)accessibleObject).getName(), ReflectiveConfigBuilderImpl.staticToConsumer(configClass, (Method)accessibleObject).addHandler(e -> LibJf.LOGGER.error("Could not apply preset", e)));
                    continue;
                }
                if (!accessibleObject.isAnnotationPresent(Verifier.class)) continue;
                builder.addVerifier(ReflectiveConfigBuilderImpl.staticToConsumer(configClass, (Method)accessibleObject).addHandler(e -> LibJf.LOGGER.error("Could not run verifier", e)));
            }
            catch (Throwable t) {
                LibJf.LOGGER.error("Could not process method " + ((Method)accessibleObject).getName() + " of config class " + configClass.getName());
            }
        }
        for (AnnotatedElement annotatedElement : configClass.getClasses()) {
            if (!((Class)annotatedElement).isAnnotationPresent(Category.class)) continue;
            Category annotation = ((Class)annotatedElement).getAnnotation(Category.class);
            Object name = ((Class)annotatedElement).getSimpleName();
            name = Character.toLowerCase(((String)name).charAt(0)) + ((String)name).substring(1);
            Function<CategoryBuilder, CategoryBuilder> categoryTweaker = this.findTweaker(annotation.tweaker(), CategoryBuilder.class);
            builder.category((String)name, arg_0 -> this.lambda$applyCategory$2((Class)annotatedElement, categoryTweaker, arg_0));
        }
        return tweaker.apply(builder);
    }

    private <T> Function<T, T> findTweaker(Class<?> targetClass, Class<T> tweakedClass) {
        try {
            return Objects.equals(targetClass, Void.TYPE) ? Function.identity() : Reflect.staticFunction(targetClass, (String)"tweak", tweakedClass, tweakedClass);
        }
        catch (Throwable t) {
            LibJf.LOGGER.error("Could not find tweaker " + targetClass + " for mod " + this.id, t);
            return Function.identity();
        }
    }

    public static <T> ThrowingConsumer<T, Throwable> staticToConsumer(Class<?> klazz, Method method) throws Throwable {
        Runnable rn = Reflect.staticProcedure(klazz, (String)method.getName());
        return c -> rn.run();
    }

    private /* synthetic */ CategoryBuilder lambda$applyCategory$2(Class categoryClass, Function categoryTweaker, CategoryBuilder builder1) {
        return this.applyCategory(builder1, categoryClass, categoryTweaker, AuxiliaryMetadata.of((Category)categoryClass.getAnnotation(Category.class)));
    }
}

