/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.unsafe.asm.patch;

import io.gitlab.jfronny.libjf.LibJf;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class PatchDebug {
    public static void print(InsnList instructions) {
        StringBuilder sb = new StringBuilder("InsnList:");
        for (AbstractInsnNode node : instructions) {
            sb.append('\n').append(node.getClass().getSimpleName()).append(' ').append(Integer.toHexString(node.getOpcode()));
            if (node instanceof VarInsnNode) {
                VarInsnNode v = (VarInsnNode)node;
                sb.append(' ').append(v.var);
                continue;
            }
            if (node instanceof LabelNode) {
                LabelNode v = (LabelNode)node;
                sb.append(' ').append(v.getLabel().toString());
                continue;
            }
            if (!(node instanceof MethodInsnNode)) continue;
            MethodInsnNode v = (MethodInsnNode)node;
            sb.append(" L").append(v.owner).append(';').append(v.name).append(v.desc).append(" (I=").append(v.itf).append(')');
        }
        LibJf.LOGGER.debug(sb.toString());
    }
}

