/*
 * Decompiled with CFR 0.152.
 */
package de.guntram.mcmod.fabrictools;

import com.google.common.collect.Lists;
import de.guntram.mcmod.fabrictools.ConfigurationItem;
import de.guntram.mcmod.fabrictools.IConfiguration;
import de.guntram.mcmod.fabrictools.Types.ConfigurationSelectList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VolatileConfiguration
implements IConfiguration {
    private Map<String, ConfigurationItem> items = new HashMap<String, ConfigurationItem>();

    public void addItem(ConfigurationItem item) {
        this.items.put(item.key, item);
    }

    @Override
    public List<String> getKeys() {
        return Lists.newArrayList(this.items.keySet());
    }

    @Override
    public Object getValue(String option) {
        return this.items.get(option).getValue();
    }

    @Override
    public boolean setValue(String option, Object value) {
        ConfigurationItem item = this.items.get(option);
        if (item == null) {
            return false;
        }
        item.setValue(value);
        return true;
    }

    @Override
    public Object getDefault(String option) {
        return this.items.get((Object)option).defaultValue;
    }

    @Override
    public Object getMin(String option) {
        return this.items.get((Object)option).minValue;
    }

    @Override
    public Object getMax(String option) {
        return this.items.get((Object)option).maxValue;
    }

    @Override
    public String getTooltip(String option) {
        return this.items.get((Object)option).toolTip;
    }

    @Override
    public boolean isSelectList(String option) {
        return this.items.get(option) instanceof ConfigurationSelectList;
    }

    @Override
    public String[] getListOptions(String option) {
        ConfigurationItem item = this.items.get(option);
        if (item instanceof ConfigurationSelectList) {
            return ((ConfigurationSelectList)item).getOptions();
        }
        return null;
    }
}

