/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.models.obj;

import com.google.common.collect.Maps;
import io.github.fabricators_of_create.porting_lib.models.obj.ObjParser;
import io.github.fabricators_of_create.porting_lib.models.obj.ObjTokenizer;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.NoSuchElementException;
import joptsimple.internal.Strings;
import net.fabricmc.fabric.api.renderer.v1.Renderer;
import net.fabricmc.fabric.api.renderer.v1.material.MaterialFinder;
import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.minecraft.class_2960;
import org.joml.Vector4f;

public class ObjMaterialLibrary {
    public static final ObjMaterialLibrary EMPTY = new ObjMaterialLibrary();
    final Map<String, Material> materials = Maps.newHashMap();

    private ObjMaterialLibrary() {
    }

    public ObjMaterialLibrary(ObjTokenizer reader) throws IOException {
        String[] line;
        Material currentMaterial = null;
        while ((line = reader.readAndSplitLine(true)) != null) {
            switch (line[0]) {
                case "newmtl": {
                    String name = Strings.join((String[])Arrays.copyOfRange(line, 1, line.length), (String)" ");
                    currentMaterial = new Material(name);
                    this.materials.put(name, currentMaterial);
                    break;
                }
                case "texture": {
                    currentMaterial.texture = new class_2960(line[1]);
                    break;
                }
                case "Ka": {
                    currentMaterial.ambientColor = ObjParser.parseVector4(line);
                    break;
                }
                case "map_Ka": {
                    currentMaterial.ambientColorMap = line[line.length - 1];
                    break;
                }
                case "Kd": {
                    currentMaterial.diffuseColor = ObjParser.parseVector4(line);
                    break;
                }
                case "forge_TintIndex": {
                    currentMaterial.diffuseTintIndex = Integer.parseInt(line[1]);
                    break;
                }
                case "map_Kd": {
                    currentMaterial.diffuseColorMap = line[line.length - 1];
                    break;
                }
                case "Ks": {
                    currentMaterial.specularColor = ObjParser.parseVector4(line);
                    break;
                }
                case "Ns": {
                    currentMaterial.specularHighlight = Float.parseFloat(line[1]);
                    break;
                }
                case "map_Ks": {
                    currentMaterial.specularColorMap = line[line.length - 1];
                    break;
                }
                case "d": {
                    currentMaterial.dissolve = Float.parseFloat(line[1]);
                    break;
                }
                case "Tr": {
                    currentMaterial.transparency = Float.parseFloat(line[1]);
                }
            }
        }
    }

    public Material getMaterial(String mat) {
        if (!this.materials.containsKey(mat)) {
            throw new NoSuchElementException("The material was not found in the library: " + mat);
        }
        return this.materials.get(mat);
    }

    public static class Material {
        public final String name;
        private RenderMaterial material;
        public class_2960 texture;
        public Vector4f ambientColor = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
        public String ambientColorMap;
        public Vector4f diffuseColor = new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
        public String diffuseColorMap;
        public Vector4f specularColor = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
        public float specularHighlight = 0.0f;
        public String specularColorMap;
        public float dissolve = 1.0f;
        public float transparency = 0.0f;
        public int diffuseTintIndex = 0;

        public RenderMaterial getMaterial(Renderer renderer) {
            if (this.material == null) {
                MaterialFinder finder = renderer.materialFinder();
                this.material = finder.find();
            }
            return this.material;
        }

        public Material(String name) {
            this.name = name;
        }
    }
}

