/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.models.obj;

import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Either;
import io.github.fabricators_of_create.porting_lib.core.PortingLib;
import io.github.fabricators_of_create.porting_lib.models.geometry.IGeometryLoader;
import io.github.fabricators_of_create.porting_lib.models.obj.ObjMaterialLibrary;
import io.github.fabricators_of_create.porting_lib.models.obj.ObjModel;
import io.github.fabricators_of_create.porting_lib.models.obj.ObjParser;
import io.github.fabricators_of_create.porting_lib.models.obj.ObjTokenizer;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelResolver;
import net.minecraft.class_1100;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import org.jetbrains.annotations.Nullable;

public class ObjLoader
implements ModelLoadingPlugin,
IGeometryLoader<ObjModel> {
    public static final class_2960 ID = PortingLib.id((String)"obj");
    public static final ObjLoader INSTANCE = new ObjLoader();
    public static final String OBJ_MARKER = PortingLib.id((String)"obj_marker").toString();
    private final Map<ObjModel.ModelSettings, ObjModel> modelCache = Maps.newConcurrentMap();
    private final Map<class_2960, ObjMaterialLibrary> materialCache = Maps.newConcurrentMap();

    public void onInitializeModelLoader(ModelLoadingPlugin.Context ctx) {
        this.modelCache.clear();
        this.materialCache.clear();
        this.findModels(xva$0 -> ctx.addModels(new class_2960[]{xva$0}));
        ctx.resolveModel().register((Object)new Resolver());
    }

    private void findModels(Consumer<class_2960> out) {
        class_3300 manager = ObjLoader.getResourceManager();
        manager.method_14488("models/misc", id -> {
            if (id.method_12832().endsWith(".json")) {
                manager.method_14486(id).ifPresent(resource -> {
                    if (this.tryLoadModelJson((class_2960)id, (class_3298)resource) != null) {
                        out.accept((class_2960)id);
                    }
                });
            }
            return true;
        });
    }

    private JsonObject tryLoadModelJson(class_2960 id, class_3298 resource) {
        try {
            JsonObject json = JsonParser.parseReader((Reader)resource.method_43039()).getAsJsonObject();
            if (json.has(OBJ_MARKER)) {
                return json;
            }
        }
        catch (IOException | IllegalStateException e) {
            PortingLib.LOGGER.error("Error loading obj model from models/misc: " + id, (Throwable)e);
        }
        return null;
    }

    private Either<ObjModel.ModelSettings, RuntimeException> tryReadSettings(JsonObject json) {
        try {
            class_2960 objLocation = new class_2960(class_3518.method_15265((JsonObject)json, (String)"model"));
            return Either.left((Object)new ObjModel.ModelSettings(objLocation, class_3518.method_15258((JsonObject)json, (String)"automaticCulling", (boolean)true), class_3518.method_15258((JsonObject)json, (String)"shadeQuads", (boolean)true), class_3518.method_15258((JsonObject)json, (String)"flipV", (boolean)true), class_3518.method_15258((JsonObject)json, (String)"emissiveAmbient", (boolean)true), class_3518.method_15253((JsonObject)json, (String)"mtlOverride", null)));
        }
        catch (RuntimeException e) {
            return Either.right((Object)e);
        }
    }

    public ObjModel read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) {
        return (ObjModel)this.tryReadSettings(jsonObject).map(this::loadModel, exception -> {
            throw new JsonParseException("Error loading OBJ model settings", (Throwable)exception);
        });
    }

    private ObjModel loadModel(ObjModel.ModelSettings settings) {
        class_2960 id = settings.modelLocation();
        class_3298 resource = (class_3298)ObjLoader.getResourceManager().method_14486(id).orElseThrow(() -> new NoSuchElementException(id.toString()));
        return this.loadModel(resource, settings);
    }

    private ObjModel loadModel(class_3298 resource, ObjModel.ModelSettings settings) {
        return this.modelCache.computeIfAbsent(settings, data -> {
            ObjModel objModel;
            ObjTokenizer tokenizer = new ObjTokenizer(resource.method_14482());
            try {
                objModel = ObjParser.parse(tokenizer, settings);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        tokenizer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException("Could not find OBJ model", e);
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not read OBJ model", e);
                }
            }
            tokenizer.close();
            return objModel;
        });
    }

    public ObjMaterialLibrary loadMaterialLibrary(class_2960 materialLocation) {
        return this.materialCache.computeIfAbsent(materialLocation, location -> {
            ObjMaterialLibrary objMaterialLibrary;
            class_3298 resource = (class_3298)ObjLoader.getResourceManager().method_14486(location).orElseThrow();
            ObjTokenizer rdr = new ObjTokenizer(resource.method_14482());
            try {
                objMaterialLibrary = new ObjMaterialLibrary(rdr);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        rdr.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException("Could not find OBJ material library", e);
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not read OBJ material library", e);
                }
            }
            rdr.close();
            return objMaterialLibrary;
        });
    }

    private static class_3300 getResourceManager() {
        return class_310.method_1551().method_1478();
    }

    private class Resolver
    implements ModelResolver {
        private Resolver() {
        }

        @Nullable
        public class_1100 resolveModel(ModelResolver.Context context) {
            class_2960 id = context.id();
            class_3300 resourceManager = ObjLoader.getResourceManager();
            return resourceManager.method_14486(id).map(resource -> {
                JsonObject json = ObjLoader.this.tryLoadModelJson(id, (class_3298)resource);
                if (json != null) {
                    return (ObjModel)ObjLoader.this.tryReadSettings(json).map(settings -> {
                        try {
                            return ObjLoader.this.loadModel(resourceManager.getResourceOrThrow(new class_2960(class_3518.method_15265((JsonObject)json, (String)"model"))), (ObjModel.ModelSettings)settings);
                        }
                        catch (FileNotFoundException e) {
                            throw new RuntimeException(e);
                        }
                    }, exception -> {
                        PortingLib.LOGGER.error("Error loading obj model: " + id, (Throwable)exception);
                        return null;
                    });
                }
                return null;
            }).orElse(null);
        }
    }
}

