/*
 * Decompiled with CFR 0.152.
 */
package org.quiltmc.qsl.frozenblock.misc.datafixerupper.api;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixerBuilder;
import com.mojang.datafixers.schemas.Schema;
import java.util.Map;
import java.util.Objects;
import net.frozenblock.lib.datafix.api.BlockStateRenameFix;
import net.minecraft.class_1182;
import net.minecraft.class_1208;
import net.minecraft.class_1211;
import net.minecraft.class_1220;
import net.minecraft.class_2960;
import net.minecraft.class_3551;
import net.minecraft.class_3579;
import net.minecraft.class_7293;
import org.jetbrains.annotations.NotNull;

public final class SimpleFixes {
    private SimpleFixes() {
        throw new RuntimeException("SimpleFixes contains only static declarations.");
    }

    public static void addBlockRenameFix(@NotNull DataFixerBuilder builder, @NotNull String name, @NotNull class_2960 oldId, @NotNull class_2960 newId, @NotNull Schema schema) {
        Objects.requireNonNull(builder, "DataFixerBuilder cannot be null");
        Objects.requireNonNull(name, "Fix name cannot be null");
        Objects.requireNonNull(oldId, "Old identifier cannot be null");
        Objects.requireNonNull(newId, "New identifier cannot be null");
        Objects.requireNonNull(schema, "Schema cannot be null");
        String oldIdStr = oldId.toString();
        String newIdStr = newId.toString();
        builder.addFixer(class_3579.method_15589((Schema)schema, (String)name, inputName -> Objects.equals(class_1220.method_5193((String)inputName), oldIdStr) ? newIdStr : inputName));
    }

    public static void addEntityRenameFix(@NotNull DataFixerBuilder builder, @NotNull String name, @NotNull class_2960 oldId, @NotNull class_2960 newId, @NotNull Schema schema) {
        Objects.requireNonNull(builder, "DataFixerBuilder cannot be null");
        Objects.requireNonNull(name, "Fix name cannot be null");
        Objects.requireNonNull(oldId, "Old identifier cannot be null");
        Objects.requireNonNull(newId, "New identifier cannot be null");
        Objects.requireNonNull(schema, "Schema cannot be null");
        final String oldIdStr = oldId.toString();
        final String newIdStr = newId.toString();
        builder.addFixer((DataFix)new class_1211(name, schema, false){

            protected String method_5163(String inputName) {
                return Objects.equals(class_1220.method_5193((String)inputName), oldIdStr) ? newIdStr : inputName;
            }
        });
    }

    public static void addItemRenameFix(@NotNull DataFixerBuilder builder, @NotNull String name, @NotNull class_2960 oldId, @NotNull class_2960 newId, @NotNull Schema schema) {
        Objects.requireNonNull(builder, "DataFixerBuilder cannot be null");
        Objects.requireNonNull(name, "Fix name cannot be null");
        Objects.requireNonNull(oldId, "Old identifier cannot be null");
        Objects.requireNonNull(newId, "New identifier cannot be null");
        Objects.requireNonNull(schema, "Schema cannot be null");
        String oldIdStr = oldId.toString();
        String newIdStr = newId.toString();
        builder.addFixer(class_1182.method_5019((Schema)schema, (String)name, inputName -> Objects.equals(class_1220.method_5193((String)inputName), oldIdStr) ? newIdStr : inputName));
    }

    public static void addBlockStateRenameFix(@NotNull DataFixerBuilder builder, @NotNull String name, @NotNull class_2960 blockId, @NotNull String oldState, @NotNull String defaultValue, @NotNull String newState, @NotNull Schema schema) {
        Objects.requireNonNull(builder, "DataFixerBuilder cannot be null");
        Objects.requireNonNull(name, "Fix name cannot be null");
        Objects.requireNonNull(blockId, "Block Id cannot be null");
        Objects.requireNonNull(oldState, "Old BlockState cannot be null");
        Objects.requireNonNull(defaultValue, "Default value cannot be null");
        Objects.requireNonNull(newState, "New BlockState cannot be null");
        Objects.requireNonNull(schema, "Schema cannot be null");
        String blockIdStr = blockId.toString();
        builder.addFixer((DataFix)new BlockStateRenameFix(schema, name, blockIdStr, oldState, defaultValue, newState));
    }

    public static void addBiomeRenameFix(@NotNull DataFixerBuilder builder, @NotNull String name, @NotNull Map<class_2960, class_2960> changes, @NotNull Schema schema) {
        Objects.requireNonNull(builder, "DataFixerBuilder cannot be null");
        Objects.requireNonNull(name, "Fix name cannot be null");
        Objects.requireNonNull(changes, "Changes cannot be null");
        Objects.requireNonNull(schema, "Schema cannot be null");
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (Map.Entry<class_2960, class_2960> entry : changes.entrySet()) {
            mapBuilder.put((Object)entry.getKey().toString(), (Object)entry.getValue().toString());
        }
        builder.addFixer((DataFix)new class_7293(schema, name, class_1208.field_5728, class_3551.method_30070((Map)mapBuilder.build())));
    }
}

