/*
 * Decompiled with CFR 0.152.
 */
package org.quiltmc.qsl.frozenblock.misc.datafixerupper.api;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.schemas.Schema;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_155;
import net.minecraft.class_2487;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;
import org.quiltmc.qsl.frozenblock.misc.datafixerupper.api.QuiltDataFixerBuilder;
import org.quiltmc.qsl.frozenblock.misc.datafixerupper.impl.QuiltDataFixesInternals;

public final class QuiltDataFixes {
    public static final BiFunction<Integer, Schema, Schema> BASE_SCHEMA = (version, parent) -> {
        Preconditions.checkArgument((version == 0 ? 1 : 0) != 0, (Object)"version must be 0");
        Preconditions.checkArgument((parent == null ? 1 : 0) != 0, (Object)"parent must be null");
        return QuiltDataFixesInternals.get().createBaseSchema();
    };

    private QuiltDataFixes() {
        throw new UnsupportedOperationException("QuiltDataFixes contains only static declarations.");
    }

    public static void registerFixer(@NotNull String modId, @Range(from=0L, to=0x7FFFFFFFL) int currentVersion, @NotNull DataFixer dataFixer) {
        Objects.requireNonNull(modId, "modId cannot be null");
        Preconditions.checkArgument((currentVersion >= 0 ? 1 : 0) != 0, (Object)"currentVersion must be positive");
        Objects.requireNonNull(dataFixer, "dataFixer cannot be null");
        if (QuiltDataFixes.isFrozen()) {
            throw new IllegalStateException("Can't register data fixer after registry is frozen");
        }
        QuiltDataFixesInternals.get().registerFixer(modId, currentVersion, dataFixer);
    }

    public static void registerFixer(@NotNull ModContainer mod, @Range(from=0L, to=0x7FFFFFFFL) int currentVersion, @NotNull DataFixer dataFixer) {
        Objects.requireNonNull(mod, "mod cannot be null");
        QuiltDataFixes.registerFixer(mod.getMetadata().getId(), currentVersion, dataFixer);
    }

    public static void buildAndRegisterFixer(@NotNull ModContainer mod, @NotNull QuiltDataFixerBuilder dataFixerBuilder) {
        Objects.requireNonNull(mod, "mod cannot be null");
        Objects.requireNonNull(dataFixerBuilder, "data fixer builder cannot be null");
        QuiltDataFixes.registerFixer(mod.getMetadata().getId(), dataFixerBuilder.getDataVersion(), QuiltDataFixes.buildFixer(dataFixerBuilder));
    }

    public static void registerMinecraftFixer(@NotNull String modId, @Range(from=0L, to=0x7FFFFFFFL) int currentVersion, @NotNull DataFixer dataFixer) {
        Objects.requireNonNull(modId, "modId cannot be null");
        Preconditions.checkArgument((currentVersion >= 0 ? 1 : 0) != 0, (Object)"currentVersion must be positive");
        Objects.requireNonNull(dataFixer, "dataFixer cannot be null");
        if (QuiltDataFixes.isFrozen()) {
            throw new IllegalStateException("Can't register data fixer after registry is frozen");
        }
        QuiltDataFixesInternals.get().registerMinecraftFixer(modId, currentVersion, dataFixer);
    }

    public static void registerMinecraftFixer(@NotNull ModContainer mod, @Range(from=0L, to=0x7FFFFFFFL) int currentVersion, @NotNull DataFixer dataFixer) {
        Objects.requireNonNull(mod, "mod cannot be null");
        QuiltDataFixes.registerMinecraftFixer(mod.getMetadata().getId(), currentVersion, dataFixer);
    }

    public static void buildAndRegisterMinecraftFixer(@NotNull ModContainer mod, @NotNull QuiltDataFixerBuilder dataFixerBuilder) {
        Objects.requireNonNull(mod, "mod cannot be null");
        Objects.requireNonNull(dataFixerBuilder, "data fixer builder cannot be null");
        QuiltDataFixes.registerMinecraftFixer(mod.getMetadata().getId(), dataFixerBuilder.getDataVersion(), QuiltDataFixes.buildFixer(dataFixerBuilder));
    }

    public static DataFixer buildFixer(@NotNull QuiltDataFixerBuilder dataFixerBuilder) {
        Objects.requireNonNull(dataFixerBuilder, "data fixer builder cannot be null");
        Supplier<Executor> executor = () -> Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("FrozenLib Quilt Datafixer Bootstrap").setDaemon(true).setPriority(1).build());
        return dataFixerBuilder.build(class_155.field_43095, executor);
    }

    @NotNull
    public static Optional<DataFixer> getFixer(@NotNull String modId) {
        Objects.requireNonNull(modId, "modId cannot be null");
        QuiltDataFixesInternals.DataFixerEntry entry = QuiltDataFixesInternals.get().getFixerEntry(modId);
        if (entry == null) {
            return Optional.empty();
        }
        return Optional.of(entry.dataFixer());
    }

    @NotNull
    public static Optional<DataFixer> getMinecraftFixer(@NotNull String modId) {
        Objects.requireNonNull(modId, "modId cannot be null");
        QuiltDataFixesInternals.DataFixerEntry entry = QuiltDataFixesInternals.get().getMinecraftFixerEntry(modId);
        if (entry == null) {
            return Optional.empty();
        }
        return Optional.of(entry.dataFixer());
    }

    @Contract(pure=true)
    public static @Range(from=0L, to=0x7FFFFFFFL) int getModDataVersion(@NotNull class_2487 compound, @NotNull String modId) {
        Objects.requireNonNull(compound, "compound cannot be null");
        Objects.requireNonNull(modId, "modId cannot be null");
        return QuiltDataFixesInternals.getModDataVersion(compound, modId);
    }

    @Contract(pure=true)
    public static @Range(from=0L, to=0x7FFFFFFFL) int getModMinecraftDataVersion(@NotNull class_2487 compound, @NotNull String modId) {
        Objects.requireNonNull(compound, "compound cannot be null");
        Objects.requireNonNull(modId, "modId cannot be null");
        return QuiltDataFixesInternals.getModMinecraftDataVersion(compound, modId);
    }

    @Contract(pure=true)
    public static boolean isFrozen() {
        return QuiltDataFixesInternals.get().isFrozen();
    }
}

