/*
 * Decompiled with CFR 0.152.
 */
package org.quiltmc.qsl.frozenblock.misc.datafixerupper.api;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.DataFixerBuilder;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public class QuiltDataFixerBuilder
extends DataFixerBuilder {
    protected final int dataVersion;

    public QuiltDataFixerBuilder(@Range(from=0L, to=0x7FFFFFFFL) int dataVersion) {
        super(dataVersion);
        this.dataVersion = dataVersion;
    }

    public @Range(from=0L, to=0x7FFFFFFFL) int getDataVersion() {
        return this.dataVersion;
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public DataFixer build(Set<DSL.TypeReference> types, @NotNull Supplier<Executor> executorGetter) {
        return types.isEmpty() ? this.buildUnoptimized() : this.buildOptimized(types, executorGetter.get());
    }
}

