/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.worldgen.surface.api;

import java.util.ArrayList;
import java.util.List;
import net.frozenblock.lib.worldgen.surface.api.FrozenDimensionBoundRuleSource;
import net.frozenblock.lib.worldgen.surface.api.SurfaceRuleEvents;
import net.frozenblock.lib.worldgen.surface.impl.BiomeTagConditionSource;
import net.frozenblock.lib.worldgen.surface.impl.OptimizedBiomeTagConditionSource;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6686;
import net.minecraft.class_6862;
import net.minecraft.class_7134;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FrozenSurfaceRules {
    public static final class_6686.class_6708 AIR = FrozenSurfaceRules.makeStateRule(class_2246.field_10124);
    public static final class_6686.class_6708 BEDROCK = FrozenSurfaceRules.makeStateRule(class_2246.field_9987);
    public static final class_6686.class_6708 WHITE_TERRACOTTA = FrozenSurfaceRules.makeStateRule(class_2246.field_10611);
    public static final class_6686.class_6708 ORANGE_TERRACOTTA = FrozenSurfaceRules.makeStateRule(class_2246.field_10184);
    public static final class_6686.class_6708 TERRACOTTA = FrozenSurfaceRules.makeStateRule(class_2246.field_10415);
    public static final class_6686.class_6708 RED_SAND = FrozenSurfaceRules.makeStateRule(class_2246.field_10534);
    public static final class_6686.class_6708 RED_SANDSTONE = FrozenSurfaceRules.makeStateRule(class_2246.field_10344);
    public static final class_6686.class_6708 STONE = FrozenSurfaceRules.makeStateRule(class_2246.field_10340);
    public static final class_6686.class_6708 DEEPSLATE = FrozenSurfaceRules.makeStateRule(class_2246.field_28888);
    public static final class_6686.class_6708 DIRT = FrozenSurfaceRules.makeStateRule(class_2246.field_10566);
    public static final class_6686.class_6708 PODZOL = FrozenSurfaceRules.makeStateRule(class_2246.field_10520);
    public static final class_6686.class_6708 COARSE_DIRT = FrozenSurfaceRules.makeStateRule(class_2246.field_10253);
    public static final class_6686.class_6708 MYCELIUM = FrozenSurfaceRules.makeStateRule(class_2246.field_10402);
    public static final class_6686.class_6708 GRASS_BLOCK = FrozenSurfaceRules.makeStateRule(class_2246.field_10219);
    public static final class_6686.class_6708 CALCITE = FrozenSurfaceRules.makeStateRule(class_2246.field_27114);
    public static final class_6686.class_6708 GRAVEL = FrozenSurfaceRules.makeStateRule(class_2246.field_10255);
    public static final class_6686.class_6708 SAND = FrozenSurfaceRules.makeStateRule(class_2246.field_10102);
    public static final class_6686.class_6708 SANDSTONE = FrozenSurfaceRules.makeStateRule(class_2246.field_9979);
    public static final class_6686.class_6708 PACKED_ICE = FrozenSurfaceRules.makeStateRule(class_2246.field_10225);
    public static final class_6686.class_6708 SNOW_BLOCK = FrozenSurfaceRules.makeStateRule(class_2246.field_10491);
    public static final class_6686.class_6708 MUD = FrozenSurfaceRules.makeStateRule(class_2246.field_37576);
    public static final class_6686.class_6708 POWDER_SNOW = FrozenSurfaceRules.makeStateRule(class_2246.field_27879);
    public static final class_6686.class_6708 ICE = FrozenSurfaceRules.makeStateRule(class_2246.field_10295);
    public static final class_6686.class_6708 WATER = FrozenSurfaceRules.makeStateRule(class_2246.field_10382);
    public static final class_6686.class_6708 LAVA = FrozenSurfaceRules.makeStateRule(class_2246.field_10164);
    public static final class_6686.class_6708 NETHERRACK = FrozenSurfaceRules.makeStateRule(class_2246.field_10515);
    public static final class_6686.class_6708 SOUL_SAND = FrozenSurfaceRules.makeStateRule(class_2246.field_10114);
    public static final class_6686.class_6708 SOUL_SOIL = FrozenSurfaceRules.makeStateRule(class_2246.field_22090);
    public static final class_6686.class_6708 BASALT = FrozenSurfaceRules.makeStateRule(class_2246.field_22091);
    public static final class_6686.class_6708 BLACKSTONE = FrozenSurfaceRules.makeStateRule(class_2246.field_23869);
    public static final class_6686.class_6708 WARPED_WART_BLOCK = FrozenSurfaceRules.makeStateRule(class_2246.field_22115);
    public static final class_6686.class_6708 WARPED_NYLIUM = FrozenSurfaceRules.makeStateRule(class_2246.field_22113);
    public static final class_6686.class_6708 NETHER_WART_BLOCK = FrozenSurfaceRules.makeStateRule(class_2246.field_10541);
    public static final class_6686.class_6708 CRIMSON_NYLIUM = FrozenSurfaceRules.makeStateRule(class_2246.field_22120);
    public static final class_6686.class_6708 ENDSTONE = FrozenSurfaceRules.makeStateRule(class_2246.field_10471);

    public static class_6686.class_6710 sequence(@NotNull List<class_6686.class_6708> list) {
        return new class_6686.class_6710(list);
    }

    public static class_6686.class_6693 isBiome(@NotNull List<class_5321<class_1959>> biomes) {
        return class_6686.method_39054(biomes);
    }

    public static class_6686.class_6693 isBiomeTag(@NotNull class_6862<class_1959> biomeTagKey) {
        return new BiomeTagConditionSource(biomeTagKey);
    }

    public static class_6686.class_6693 isBiomeTagOptimized(@NotNull class_6862<class_1959> biomeTagKey) {
        return new OptimizedBiomeTagConditionSource(biomeTagKey);
    }

    public static class_6686.class_6708 makeStateRule(@NotNull class_2248 block) {
        return class_6686.method_39047((class_2680)block.method_9564());
    }

    @Nullable
    public static class_6686.class_6708 getSurfaceRules(class_5321<class_2874> dimension) {
        if (dimension == null) {
            return null;
        }
        class_2960 location = dimension.method_29177();
        class_6686.class_6708 returnValue = null;
        if (location.equals((Object)class_7134.field_37666.method_29177()) || location.equals((Object)class_7134.field_37669.method_29177())) {
            returnValue = FrozenSurfaceRules.getOverworldSurfaceRules();
        } else if (location.equals((Object)class_7134.field_37667.method_29177())) {
            returnValue = FrozenSurfaceRules.getNetherSurfaceRules();
        } else if (location.equals((Object)class_7134.field_37668.method_29177())) {
            returnValue = FrozenSurfaceRules.getEndSurfaceRules();
        }
        class_6686.class_6708 generic = FrozenSurfaceRules.getGenericSurfaceRules(dimension);
        if (generic != null) {
            returnValue = returnValue == null ? generic : class_6686.method_39050((class_6686.class_6708[])new class_6686.class_6708[]{returnValue, generic});
        }
        return returnValue;
    }

    @Nullable
    public static class_6686.class_6708 getOverworldSurfaceRules() {
        class_6686.class_6710 newRule = null;
        ArrayList<class_6686.class_6708> sourceHolders = new ArrayList<class_6686.class_6708>();
        ((SurfaceRuleEvents.OverworldSurfaceRuleCallback)SurfaceRuleEvents.MODIFY_OVERWORLD.invoker()).addOverworldSurfaceRules(sourceHolders);
        class_6686.class_6710 newSource = FrozenSurfaceRules.sequence(sourceHolders);
        newRule = newSource = class_6686.method_39049((class_6686.class_6693)class_6686.method_39473(), (class_6686.class_6708)newSource);
        ArrayList<class_6686.class_6708> noPrelimSourceHolders = new ArrayList<class_6686.class_6708>();
        ((SurfaceRuleEvents.OverworldSurfaceRuleNoPrelimSurfaceCallback)SurfaceRuleEvents.MODIFY_OVERWORLD_NO_PRELIMINARY_SURFACE.invoker()).addOverworldNoPrelimSurfaceRules(noPrelimSourceHolders);
        class_6686.class_6710 noPrelimSource = FrozenSurfaceRules.sequence(noPrelimSourceHolders);
        newRule = class_6686.method_39050((class_6686.class_6708[])new class_6686.class_6708[]{noPrelimSource, newRule});
        return newRule;
    }

    @Nullable
    public static class_6686.class_6708 getNetherSurfaceRules() {
        class_6686.class_6708 newSource = null;
        ArrayList<class_6686.class_6708> sourceHolders = new ArrayList<class_6686.class_6708>();
        ((SurfaceRuleEvents.NetherSurfaceRuleCallback)SurfaceRuleEvents.MODIFY_NETHER.invoker()).addNetherSurfaceRules(sourceHolders);
        for (class_6686.class_6708 rule : sourceHolders) {
            if (newSource == null) {
                newSource = rule;
                continue;
            }
            newSource = class_6686.method_39050((class_6686.class_6708[])new class_6686.class_6708[]{newSource, rule});
        }
        return newSource;
    }

    @Nullable
    public static class_6686.class_6708 getEndSurfaceRules() {
        class_6686.class_6708 newSource = null;
        ArrayList<class_6686.class_6708> sourceHolders = new ArrayList<class_6686.class_6708>();
        ((SurfaceRuleEvents.EndSurfaceRuleCallback)SurfaceRuleEvents.MODIFY_END.invoker()).addEndSurfaceRules(sourceHolders);
        for (class_6686.class_6708 rule : sourceHolders) {
            if (newSource == null) {
                newSource = rule;
                continue;
            }
            newSource = class_6686.method_39050((class_6686.class_6708[])new class_6686.class_6708[]{newSource, rule});
        }
        return newSource;
    }

    @Nullable
    public static class_6686.class_6708 getGenericSurfaceRules(class_5321<class_2874> dimension) {
        class_6686.class_6708 newSource = null;
        ArrayList<FrozenDimensionBoundRuleSource> sourceHolders = new ArrayList<FrozenDimensionBoundRuleSource>();
        ((SurfaceRuleEvents.GenericSurfaceRuleCallback)SurfaceRuleEvents.MODIFY_GENERIC.invoker()).addGenericSurfaceRules(sourceHolders);
        for (FrozenDimensionBoundRuleSource dimRuleSource : sourceHolders) {
            if (!dimRuleSource.dimension().equals((Object)dimension.method_29177())) continue;
            if (newSource == null) {
                newSource = dimRuleSource.ruleSource();
                continue;
            }
            newSource = class_6686.method_39050((class_6686.class_6708[])new class_6686.class_6708[]{newSource, dimRuleSource.ruleSource()});
        }
        return newSource;
    }
}

